;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_IPAD
;
; Purpose     :	Adds IIMS IPAD data to IPAD IF data set.
;
; Explanation : Adds IIMS IPAD data to IPAD IF data set.
;
; Use         : < rcs_add_ipad, sc, vs, time, ipad, mvals, flag  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               ipad        : FLTARR ( nsectors, ndetectors, nenergies )  counts
;               mvals       : BYTARR M values.
;               flag        : BYTE flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_ipad, sc, vs, time, ipad, mvals, flag

  ; global common block

  COMMON rcs_ipad_block, header, data

  ; get no. of sectors in use
  ; this can not be dynamically changed without a reset of the common block

  no_of_sectors = (SIZE(ipad))[1]

  ; add to header and data
  ; cancel bad LUT flag and subc invalid flag

  rcs_add_data, rcs_get_scname(sc)+'_IIMS_IPAD_'+rcs_strtrim(no_of_sectors), sc, vs, 'IPAD', rcs_get_scname(sc)+' I-PAD', $
                no_of_sectors, time, header, data, ipad, 0, flag AND 'CF'X, 4.0, MVALS=mvals

END
