;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_ISPCT
;
; Purpose     :	Adds IIMS ISPCT data to ISPCT IF data sets.
;
; Explanation : Adds IIMS ISPCT data to ISPCT IF data sets.
;
; Use         : < rcs_add_ispct, sc, vs, time, ispct, subc, flag  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               ispct       : FLTARR counts
;               subc        : INT subcommutation index
;               flag        : BYTE flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_ispct, sc, vs, time, ispct, subc, flag

  ; global common block

  COMMON rcs_ispct_He_block, header_He, data_He

  COMMON rcs_ispct_CNO_block, header_CNO, data_CNO

  no = 4

  subc = subc MOD no

  tflag = flag

  new_sample = rcs_subc( header_He, data_He, subc, no, tflag)

  tflag = flag

  new_sample = rcs_subc( header_CNO, data_CNO, subc, no, tflag)

  ; create new samples with zeroes
  ; if new set of data or missing data packets

  IF new_sample THEN BEGIN

    ; create new data sample
    ; cancel LUT flag bit

    rcs_add_data, rcs_get_scname(sc)+'_IIMS_ISPCT_He', sc, vs, 'ISPCT_He', rcs_get_scname(sc)+' ISPCT He', 1, time, header_He, data_He, 0.0,0, tflag AND 'EF'X, 16.

    rcs_add_data, rcs_get_scname(sc)+'_IIMS_ISPCT_CNO', sc, vs, 'ISPCT_CNO', rcs_get_scname(sc)+' ISPCT CNO', 1, time, header_CNO, data_CNO, 0.0, 0, tflag AND 'EF'X, 16.

  ENDIF

  ; insert data[nenergies,nspecies] into data.data[no_of_sectors,no_of_detectors,no_of_energies,no_of_points]

  CASE subc OF

    0 : data_He[header_He.npoints-1].data[0,0,0:3] = ispct

    1 : data_He[header_He.npoints-1].data[0,0,4:7] = ispct

    2 : data_CNO[header_CNO.npoints-1].data[0,0,0:3] = ispct

    3 : data_CNO[header_CNO.npoints-1].data[0,0,4:7] = ispct

  ENDCASE

END
