;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_MTRX
;
; Purpose     : Adds IIMS MTRX data to MTRX IF data set.
;
; Explanation : Adds IIMS MTRX data to MTRX IF data set.
;
; Use         : < rcs_add_mtrx, sc, vs, time, mtrx, subc, flag  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING 2 characters giving source and version
;               time        : DOUBLE TAI time of start of EDB
;               mtrx        : FLTARR data
;               subc        : INT subcommutation index
;               flag        : BYTE flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_mtrx, sc, vs, time, mtrx, subc, flag

  ; global common block

  COMMON rcs_mtrx_block, header, data

  no = 256

  subc = subc MOD no

  tflag = flag

  ; create new samples with zeroes
  ; if new set of data or missing data packets

  IF rcs_subc( header, data, subc, no, tflag) THEN BEGIN

    ; create new data sample
    ; cancel LUT flag

    rcs_add_data, rcs_get_scname(sc)+'_IIMS_MTRX', sc, vs, 'MTRX', rcs_get_scname(sc)+' MTRX', 32, time, header, data, 0.0, 0, tflag AND 'EF'X, 256.0

  ENDIF

  ; insert data[nenergies,nspecies] into data.data[no_of_sectors,no_of_detectors,no_of_energies,no_of_points]

  data[header.npoints-1].data[subc*8:subc*8+7] = mtrx

END
