;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_PEDESTAL
;
; Purpose     :	Adds IES data to PEDESTAL IF data set.
;
; Explanation : Adds IES data to PEDESTAL IF data set.
;
; Use         : < rcs_add_pedestal, sc, vs, time, clean, flag, lut_no, output_chans  >
;
; Inputs      : sc          : STRING containing spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               pedestal    : FLTARR ( ndetectors, nenergies )
;               flag        : BYTE flag bits
;               lut_no      : INT LUT used : 0-3.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 6/2/01
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 20/06/02
;                 Added extra version number to structure name since
;                 changed structure definition
;               Version 0.3, 25/11/02
;                 Removed unused test of header set.
;               Version 0.4, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.4, 29/09/03
;-
;**********************************************************

PRO rcs_add_pedestal, sc, vs, time, pedestal, flag, lut_no

  ; global common block

  COMMON rcs_pedestal_block, header, data

  ; add to header and data
  ; cancel subc flag since not subcommutated

  rcs_add_data, rcs_get_scname(sc)+'_IES_PEDESTAL', sc, vs, 'PEDESTAL', rcs_get_scname(sc)+' E-3DD PEDESTAL', $
      1, time, header, data, pedestal, lut_no, flag AND 'DF'X, 4.0, EXDATA='V1'

END
