;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_SCINFO
;
; Purpose     : Adds SCINFO data to IF data set.
;
; Explanation : Adds SCINFO data to IF data set.
;
; Use         : < rcs_add_scinfo, sc, vs, time, scinfo, flag, lut_no >
;
; Inputs      : sc      : STRING character giving spacecraft ID
;               vs      : STRING IF version 'sss_v_a_b'
;               time    : DOUBLE TAI time of start of EDB
;               scinfo  : INTARR[2] containing :
;                  0 : INT result from check_edb
;                  1 : INT subcommutation index
;               flag    : BYTE flag bits
;               lut_no  : INT IES LUT no : 0-3.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_scinfo, sc, vs, time,  scinfo, flag, lut_no

  ; global common block

  COMMON rcs_scinfo_block, header, data

  ; add to header and data

  IF NOT KEYWORD_SET(header) THEN ptitle = ['EDB CHECK','SUBC']

  rcs_add_data, rcs_get_scname(sc)+'_SCINFO', sc, vs, 'SCINFO', rcs_get_scname(sc)+' SCINFO', 1, time, header, data, scinfo, lut_no, flag, 8.0, PTITLE=ptitle

END
