;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_SGL01
;
; Purpose     : Adds IIMS SGL0 and SGL1 data to SGL01 IF data set.
;
; Explanation : Adds IIMS SGL0 and SGL1 data to SGL01 IF data set.
;
; Use         : < rcs_add_sgl01, sc, vs, time, sgl01, subc, flag  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               sgl01       : FLTARR data
;               subc        : INT subcommutation index
;               flag        : BYTE flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_sgl01, sc, vs, time, sgl01, subc, flag

  ; global common block

  COMMON rcs_sgl01_block, header, data

  IF NOT KEYWORD_SET(header) THEN ptitle = ['ENY','TCR','TAC','STA0-7','ST00-7','STA8-15','STO8-15']

  no = 4

  subc = subc MOD no

  tflag = flag

  ; create new samples with zeroes
  ; if new set of data or missing data packets

  IF rcs_subc( header, data, subc, no, tflag) THEN BEGIN

    ; create new data sample
    ; cancel lut invalid flag

    rcs_add_data, rcs_get_scname(sc)+'_IIMS_SGL01', sc, vs, 'SGL01', rcs_get_scname(sc)+' SGL01', 1, time, header, data, 0.0, 0, tflag AND 'EF'X, 16.0, PTITLE=ptitle

  ENDIF

  ; insert data into data.data[no_of_sectors,no_of_detectors,no_of_energies,no_of_points]

  data[header.npoints-1].data[0,([3,5,4,6])[subc],0] = sgl01[0]

  IF subc LE 2 THEN data[header.npoints-1].data[0,subc,0] = sgl01[1]

END
