;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_SGL2
;
; Purpose     : Adds IIMS SGL2 data to SGL2 IF data set.
;
; Explanation : Adds IIMS SGL2 data to SGL2 IF data set.
;
; Use         : < rcs_add_sgl2, sc, vs, time, sgl2, subc, flag  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               sgl2        : FLTARR data
;               subc        : INT subcommutation index
;               flag        : BYTE flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_sgl2, sc, vs, time, sgl2, subc, flag

  ; global common block

  COMMON rcs_sgl2_block, header, data

  no = 8

  subc = subc MOD no

  tflag = flag

  ; create new samples with zeroes
  ; if new set of data or missing data packets

  IF rcs_subc( header, data, subc, no, tflag) THEN BEGIN

    ; set acc time based on mode

    IF (flag MOD 2) THEN acc = 8.0 ELSE acc = 16.0

    IF NOT KEYWORD_SET(header) THEN ptitle = ['EDI1','EDI2','EDI3','BDI1','BDI2','BDI3',$
      'EDI11','EDI12','EDI13','EDI14','EDI21','EDI22','EDI23','EDI24','EDI31','EDI32','EDI33', 'EDI34']

    IF subc NE 0 THEN flag = flag OR '20'X

    rcs_add_data, rcs_get_scname(sc)+'_IIMS_SGL2', sc, vs, 'SGL2', rcs_get_scname(sc)+' SGL2', 1, time, header, data, 0.0, 0, tflag AND 'EF'X, acc, PTITLE=ptitle

  ENDIF

  ; insert data into data.data[no_of_sectors,no_of_detectors,no_of_energies,no_of_points]

  IF subc LE 5 THEN data[header.npoints-1].data[0,subc*3:subc*3+2,0] = sgl2

END
