;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_SGL3
;
; Purpose     : Adds IIMS SGL3 data to SGL3 IF data set.
;
; Explanation : Adds IIMS SGL3 data to SGL3 IF data set.
;
; Use         : < rcs_add_sgl3, sc, vs, time, sgl3, subc, flag  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               sgl3        : FLTARR data
;               subc        : INT subcommutation index
;               flag        : BYTE flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.2, 29/09/03
;-
;**********************************************************

PRO rcs_add_sgl3, sc, vs, time, sgl3, subc, flag

  ; global common block

  COMMON rcs_sgl3_block, header, data

  no = 32

  subc = subc MOD no

  tflag = flag

  ; create new samples with zeroes
  ; if new set of data or missing data packets

  IF rcs_subc( header, data, subc, no, tflag) THEN BEGIN

    ; set acc time based on mode

    IF (flag MOD 2) THEN acc = 8.0 ELSE acc = 16.0

    IF NOT KEYWORD_SET(header) THEN ptitle = ['OVF1','OVF2','OVF3','SDIR-S1','SDIR-S2','SDIR-S3',$
      'SDIR-3S','TAC-S1','TAC-S2','TAC-S3','TAC11','TAC12','TAC13','TAC14','TAC21','TAC22','TAC23','TAC24',$
      'TAC31','TAC32','TAC33','TAC34']

    rcs_add_data, rcs_get_scname(sc)+'_IIMS_SGL3', sc, vs, 'SGL3', rcs_get_scname(sc)+' SGL3', 1, time, header, data, 0.0, 0, flag AND 'EF'X, acc, PTITLE=ptitle

  ENDIF

  ; insert data into data.data[no_of_sectors,no_of_detectors,no_of_energies,no_of_points]

  IF subc GE 2 AND subc LE 23 THEN data[header.npoints-1].data[0,subc-2,0] = sgl3

END
