;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_SGLBM
;
; Purpose     : Adds IIMS SGL data to SGLBM IF data set.
;
; Explanation : Adds IIMS SGL data to SGLBM IF data set.
;
; Use         : < rcs_add_sglbm, sc, vs, time, sglbm, flag  >
;
; Inputs      : sc          : STRING character giving spacecraft ID
;               vs          : STRING IF version 'sss_v_a_b'
;               time        : DOUBLE TAI time of start of EDB
;               sglbm       : FLTARR ( nsectors, ndetectors, nenergies ) counts
;               flag        : BYTE flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 18/07/01
;                 Added CDROM version number.
;               Version 0.2, 26/07/02
;                 Changed accumulation time from 8 to 4 secs.
;               Version 0.3, 29/09/03
;                 Added SC to title.
;
; Version     :	Version 0.3, 29/09/03
;-
;**********************************************************

PRO rcs_add_sglbm, sc, vs, time, sglbm, flag

  ; global common block

  COMMON rcs_sglbm_block, header, data

  ; get no. of sectors in use
  ; this can not be dynamically changed without a reset of the common block

  no_of_sectors = (SIZE(sglbm))[1]

  IF NOT KEYWORD_SET(header) THEN ptitle = ['ENY','TCR','TAC','STA','ST0']

  ; create new samples

  rcs_add_data, rcs_get_scname(sc)+'_IIMS_SGLBM', sc, vs, 'SGLBM', rcs_get_scname(sc)+' SGLBM', no_of_sectors, time, header, data, sglbm, 0, flag AND 'CF'X, 4.0, PTITLE=ptitle

END
