;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADJUST_COMMON
;
; Purpose     :	Removes unwanted data from COMMON block.
;
; Explanation : Removes unwanted data from COMMON block
;
; Use         : < RCS_ADJUST_COMMON >
;
; Inputs      : last_pos : LONG index into data of first data required to keep.
;
; Opt. Inputs : None.
;
; Outputs     :
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       :
;
; Common      : ccsnm_data_block
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

PRO rcs_adjust_common, last_pos, data, headers

  IF KEYWORD_SET(headers) THEN nheaders = N_ELEMENTS(headers) ELSE nheaders = 0

  ; ignore possibility that data=0 is valid

  IF KEYWORD_SET(data) THEN data_size = N_ELEMENTS(data) ELSE data_size = 0

  ; remove input data from COMMON block

  data_size = data_size - last_pos

  IF data_size GT 0 THEN data = data[last_pos:*] ELSE data = 0

  ; adjust headers data

  IF nheaders GT 0 THEN BEGIN

    ; re-index headers with respect to data

    headers.index = headers.index - last_pos

    ; only keep one time

    list = WHERE(headers.index GE 0, count)

    IF count EQ 0 THEN BEGIN
      ; keep last
      headers = headers[nheaders-1]
    ENDIF ELSE IF list[0] GT 0 THEN BEGIN
      headers = headers[[list[0]-1,list]]
    ENDIF ELSE BEGIN
      headers = headers[list]
    ENDELSE

  ENDIF

END