;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	rcs_adjust_lut
;
; Purpose     :	Gives LUT number appropriate to a particular time.
;
; Explanation : There are 4 LUT values corresponding to the different integration times.
;               The LUT numbers are incremented by 4 each time the LUTs are updated.
;               This routine returns the LUT appropriate to a particular time.
;
; Use         : <lut = rcs_adjust_lut( time, lut, lut_times)>
;
; Inputs      : time      : DOUBLE TAI time
;               lut       : INT LUT number 0-3
;               lut_times : DBLARR(nchanges) TAI times of LUT changes.
;
; Opt. Inputs : None.
;
; Outputs     : lut        : INT adjusted LUT number.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 17/9/00
;-
;**********************************************************

FUNCTION rcs_adjust_lut, time, lut, lut_times

  ; deal with LUT changes

  count = TOTAL(time GE lut_times)

  IF count EQ 0 THEN rcs_message, 'INVALID LUT TIMES'

  RETURN, lut + 4*(FIX(count)-1)

END
