;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CHECK_BM
;
; Purpose     :	Checks EDB type ie BM or NM.
;
; Explanation : Checks EDB type ie BM or NM.
;               Returns 0 : NM, 1: BM.
;
; Use         : < mode = rcs_check_bm(type) >
;
; Inputs      : type    : INT indicates telemetry mode of packet
;                           0 : nm
;                           1 : bm1
;                           2 : bm2
;                           3 : bm3
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 08/07/02
;
; Modified    :	Version 0.1, 20/07/02
;                 Added check for invalid mode.
;
; Version     :	Version 0.1, 20/07/02
;-
;**********************************************************

FUNCTION rcs_check_bm, type

  ; check type

;  RETURN, (type MOD 2) EQ 1

  IF type LT 0 OR type GT 3 THEN rcs_message, 'INVALID MODE TYPE : '+STRING(type)

  RETURN, type AND 1

END
