;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CHECK_HK
;
; Purpose     :	Plots EDBs from NM EDB data stream.
;
; Explanation : Plots EDBs from NM EDB data stream.
;
; Use         : < RCS_PLOT_CCSNM >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     :
;
; Opt. Outputs: None.
;
; Keywords    : RESET   : FLAG indicating reset.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	Version 0.1, 13/12/00
;                 Added SILENT keyword.
;            	Version 0.2, 10/2/01
;                 Removed SILENT keyword.
;               Version 0.3, 14/03/01
;                 Removed ids from rcs_text and this argument list.
;               Version 0.4, 22/04/01
;                 Changed name of COMMON block.
;                 Added erdifind qualifier.
;
; Version     :	Version 0.4, 22/04/01
;-
;**********************************************************

FUNCTION rcs_check_hk, edb, lut_no

  ; global common blocks

  COMMON rcs_hk_qualifier_block, current_lut_no, current_erdifind

  ; use ERECMDRT to derive the LUT for HK data

  CASE edb[17] OF
    '00'XB : lut_no = 0
    '80'XB : lut_no = 1
    '40'XB : lut_no = 2
    'C0'XB : lut_no = 3
    ELSE : BEGIN
        rcs_text, 'WARNING, INVALID LUT IN ERECMDRT : '+STRING(edb[17],FORMAT='(Z2)')
        lut_no = -1
      END
  ENDCASE

  ; set current lut no (nb current lut no valid)

  IF lut_no GE 0 AND lut_no LE 3 THEN current_lut_no = lut_no

  ; set up current erdifind

  current_erdifind = edb[1] AND '40'X

  RETURN, 0

END
