;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CHECK_IES
;
; Purpose     :	Checks integrity of IES data.
;
; Explanation : Checks integrity of IES data.
;
; Use         : < cts = rcs_check_ies(mode, data, flag) >
;
; Inputs      : mode : INT LUT mode
;               data : FLTARR(ndetectors, nenergies) raw counts summed over spin
;                         If KEYWORD HIST then FLTARR(256)
;               flag : LONG error flag for sample
;
; Opt. Inputs : None.
;
; Outputs     : cts : LONG expected no. of counts over spin for mode.
;
; Opt. Outputs: mode : Set up if HIST and CHECK keywords used
;
; Keywords    : HIST : Flag indicating histogram mode data
;               CHECK : FLAG indicating should check no of counts.
;                       If in histogram mode then sets mode from counts.
;                       If check used then expects mode = 0-3.
;
; Written     :	Version 0.0, 08/04/02
;
; Modified    :	Version 0.1, 14/05/02
;                 Changed to function.
;                 Added expected no. of counts.
;
; Version     :	Version 0.0, 08/04/02
;-
;**********************************************************

FUNCTION rcs_check_ies, mode, data, flag, HIST=hist, CHECK=check

  ; counts are for a single detector summed over 1 spin

  ; check whether check required

  IF KEYWORD_SET(check) THEN BEGIN

    ; set up expected counts

    counts = [[76000,81000],[70000,76000],[57000,64000],[33000,42000]]

    IF KEYWORD_SET(hist) THEN BEGIN

      ; histogram mode data

      ; sum histogram counts

      cts = TOTAL(data[0,0,0:254])

      ; get mode

      IF cts GT counts[0,0] AND cts LT counts[1,0] THEN mode = 0 ELSE $
      IF cts GT counts[0,1] AND cts LT counts[1,1] THEN mode = 1 ELSE $
      IF cts GT counts[0,2] AND cts LT counts[1,2] THEN mode = 2 ELSE $
      IF cts GT counts[0,3] AND cts LT counts[1,3] THEN mode = 3 ELSE $
                                                        mode = -1

    ENDIF ELSE BEGIN

      IF mode LT 0 OR mode GT 3 THEN RETURN, 0

      ; check total counts do not exceed max possible
      ; e3dd = FLTARR ( ndetectors, nenergies )

      dummy = WHERE(TOTAL(data,2) GT counts[1,mode], count)

      IF count GT 0 THEN flag = flag AND '20'XL

    ENDELSE

  ENDIF

  IF mode LT 0 THEN RETURN, 0

  RETURN, ([78230L, 73770L, 62136L, 39970L])[mode mod 4]

END
