;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_DECOMPRESS
;
; Purpose     :	Decompresses input data.
;
; Explanation : Decompresses input data.
;
; Use         : < result = RCS_DECOMPRESS() >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : 0 : NO DATA RETURNED.
;               1 : DATA RETURNED.
;
; Opt. Outputs: None.
;
; Keywords    : NBLOCKS : INT no. of blocks of data to be read before returning.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 13/12/00
;-
;**********************************************************

FUNCTION rcs_decompress, data

  table = LINDGEN(32)
  pos = 32L
  ind = 1L
  FOR k = 1, 10 DO BEGIN
    ind = 2*ind
    table = [table,pos+LINDGEN(16)*ind]
    pos = pos + 16*ind
  ENDFOR

  FOR k = 1,1 DO BEGIN
    ind = 4*ind
    table = [table,pos+LINDGEN(8)*ind]
    pos = pos + 8*ind
  ENDFOR

  FOR k = 1,7 DO BEGIN
    ind = 2*ind
    table = [table,pos+LINDGEN(8)*ind]
    pos = pos + 8*ind
  ENDFOR

  RETURN, table[data]

END
