;**********************************************************
;+
; Project     : CCLUSTER II - RAPID
;
; Name        : RCS_EDB_INFO
;
; Purpose     : Extract information about the supplied EDB
;
; Explanation : This function uses the third synch byte of
;             : the EDB to indentify its type. The EDB number
;             : is extracted from the fourth byte and the
;             : first content descriptor from the fifth byte.
;             : The location of the second content descriptor
;             : depends on the EDB type as determined from
;             : the synch pattern. The bit patterns in CD1
;             : and CD2 are decoded and the result returned
;             : in a structure.
;
; Use         : < edb_info >
;
; Inputs      : A BYTE array containing a valid RAPID EDB
;
; Opt. Inputs : None.
;
; Outputs     : A structure containing information on the EDB
;             : If the EDB could not be recognized the structure
;             : contains a single entry { status:0 }.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Data Access
;
; Prev. Hist. : Based on original work for Cluster I.
;
; Written     : Version 0.0, Chris Perry, RAL, 10/08/1999
;
; Modified    : Version 0.1, 14/03/01
;                 Removed ids from rcs_text argument list.
;
; Version     :	Version 0.1, 14/03/01
;-
;**********************************************************

FUNCTION rcs_edb_info, edb

	CASE edb[2] OF
	'2e'XB: BEGIN
		mode = 'NM'
		nedb = edb[3]
		cd1  = edb[4]
		cd2  = edb['14f'x]
	END

	'3d'XB: BEGIN
		mode = 'BM'
		nedb = edb[3]
		cd1  = edb[4]
		cd2  = edb['154'x]
	END

	'8b'XB: BEGIN
		mode = 'BM1'
		nedb = edb[3]
		cd1  = edb[4]
		cd2  = edb['154'x]
	END

	ELSE:   BEGIN
		rcs_text, 'ERROR - Invalid EDB'
		RETURN, {status: 0}
	END

	ENDCASE

	RETURN, {status:1, mode:mode, cd1:cd1, cd2:cd2,   $
		ifft_test: ( cd1 AND 1B ) GT 0,   $
		epp_test:  ( cd1 AND 2B ) GT 0,   $
		ram_test:  ( cd1 AND 4B ) GT 0,   $
		class_test:( cd1 AND 8B ) GT 0,   $
		fgm_data:  ( cd1 AND 16B ) GT 0,  $
		ies_cal:   ( cd1 AND 32B ) GT 0,  $
		ies_active:( cd1 AND 64B ) GT 0,  $
		iims_sim:  ( cd1 AND 128B ) GT 0, $
		ies_lut:   ( cd2 AND 31B ),       $
		ies_ptab:  ( cd2 AND 32B ) GT 0,  $
		epp_fill:  ( cd2 AND 64B ) GT 0,  $
		ies_hist:  ( cd2 AND 128B ) GT 0 }

END
