;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_EXTRACT_SC
;
; Purpose     :	Returns S/C name character.
;
; Explanation : S/C information is embedded in the IF header.datatype.
;               This routine looks at all available IF headers or optionally at a header
;               supplied.
;
; Use         : < sc = rcs_extract_sc(HEADER=header) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : sc : STRING S/C name as character
;
; Opt. Outputs: None.
;
; Keywords    : HEADER : STRUCTURE giving IF header.
;
; Written     :	Version 0.0, 17/09/00
;
; Modified    :	Version 0.1, 29/1/01
;                 Renamed.
;               Version 0.2, 6/2/01
;                 Added pedestals and espct IF data set.
;               Version 0.3, 15/05/01
;                 Added CLEANBM2.
;               Version 0.4, 08/02/02
;                 Added EPAD2.
;
; Version     :	Version 0.4, 08/02/02
;-
;**********************************************************

FUNCTION rcs_extract_sc, HEADER=header

  ; global common blocks

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  ; get S/C

  IF KEYWORD_SET(header)          THEN sc = TAG_NAMES(header,/STRUCTURE_NAME)          ELSE $
  IF KEYWORD_SET(e3ddnm_header)   THEN sc = TAG_NAMES(e3ddnm_header,/STRUCTURE_NAME)   ELSE $
  IF KEYWORD_SET(clean_header)    THEN sc = TAG_NAMES(clean_header,/STRUCTURE_NAME)    ELSE $
  IF KEYWORD_SET(cleanbm_header)  THEN sc = TAG_NAMES(cleanbm_header,/STRUCTURE_NAME)  ELSE $
  IF KEYWORD_SET(cleanbm2_header) THEN sc = TAG_NAMES(cleanbm2_header,/STRUCTURE_NAME) ELSE $
  IF KEYWORD_SET(espct_header)    THEN sc = TAG_NAMES(espct_header,/STRUCTURE_NAME)    ELSE $
  IF KEYWORD_SET(pedestal_header) THEN sc = TAG_NAMES(pedestal_header,/STRUCTURE_NAME) ELSE $
  IF KEYWORD_SET(ehist_header)    THEN sc = TAG_NAMES(ehist_header,/STRUCTURE_NAME)    ELSE $
  IF KEYWORD_SET(epad_header)     THEN sc = TAG_NAMES(epad_header,/STRUCTURE_NAME)     ELSE $
  IF KEYWORD_SET(epad2_header)    THEN sc = TAG_NAMES(epad2_header,/STRUCTURE_NAME)    ELSE $
  IF KEYWORD_SET(ehk_header)      THEN sc = TAG_NAMES(ehk_header,/STRUCTURE_NAME)      ELSE $
  IF KEYWORD_SET(i3dd_header_H)   THEN sc = TAG_NAMES(i3dd_header_H,/STRUCTURE_NAME)   ELSE $
  IF KEYWORD_SET(ipad_header)     THEN sc = TAG_NAMES(ipad_header,/STRUCTURE_NAME)     ELSE $
  IF KEYWORD_SET(hspct_header)    THEN sc = TAG_NAMES(hspct_header,/STRUCTURE_NAME)    ELSE $
  IF KEYWORD_SET(ispct_header_He) THEN sc = TAG_NAMES(ispct_header_He,/STRUCTURE_NAME) ELSE $
  IF KEYWORD_SET(mtrx_header)     THEN sc = TAG_NAMES(mtrx_header,/STRUCTURE_NAME)     ELSE $
  IF KEYWORD_SET(sglbm_header)    THEN sc = TAG_NAMES(sglbm_header,/STRUCTURE_NAME)    ELSE $
  IF KEYWORD_SET(sgl01_header)    THEN sc = TAG_NAMES(sgl01_header,/STRUCTURE_NAME)    ELSE $
  IF KEYWORD_SET(sgl2_header)     THEN sc = TAG_NAMES(sgl2_header,/STRUCTURE_NAME)     ELSE $
  IF KEYWORD_SET(sgl3_header)     THEN sc = TAG_NAMES(sgl3_header,/STRUCTURE_NAME)     ELSE $
  IF KEYWORD_SET(hk1_header)      THEN sc = TAG_NAMES(hk1_header,/STRUCTURE_NAME)      ELSE $
  IF KEYWORD_SET(hk2_header)      THEN sc = TAG_NAMES(hk2_header,/STRUCTURE_NAME)      ELSE $
  IF KEYWORD_SET(hk4_header)      THEN sc = TAG_NAMES(hk4_header,/STRUCTURE_NAME)      ELSE $
  IF KEYWORD_SET(hk8_header)      THEN sc = TAG_NAMES(hk8_header,/STRUCTURE_NAME)      ELSE $
  IF KEYWORD_SET(hk32_header)     THEN sc = TAG_NAMES(hk32_header,/STRUCTURE_NAME)     ELSE $
  IF KEYWORD_SET(scinfo_header)   THEN sc = TAG_NAMES(scinfo_header,/STRUCTURE_NAME)   ELSE $
    RETURN, ''

  ; structure name = HEADER_RAPID_sc_...

  RETURN, STRMID(sc,13,1)

END
