;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_EXTRACT_STATE
;
; Purpose     :	Updates display of state of RCS_EXTRACT.
;
; Explanation : Updates display of state of RCS_EXTRACT.
;               Deasserts data reset_flag.
;
; Use         : < rcs_extract_state, ids, HK=hk >
;
; Inputs      : ids : STRUCTURE containing widget IDs.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : HK    : Flag indicating only HK stream to update.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 10/2/01
;                 Changed silent to common block.
;               Version 0.2, 13/03/01
;                 Changed use of silent flag.
;
; Version     :	Version 0.2, 13/03/01
;-
;**********************************************************

PRO rcs_extract_state, ids, HK=hk

  COMMON rcs_extract_block, tmax, data_reset

  IF KEYWORD_SET(hk) THEN BEGIN

    ; check silent flag

    IF rcs_get_silent() THEN RETURN

    ; get size of each IF data set

    values = rcs_get_sizes(/HK)

    ; display start time of last data

    IF KEYWORD_SET(tmax) THEN values.time = anytim2cal(tmax) ELSE values.time=''

    IF WIDGET_INFO(ids.showif,/VALID_ID) THEN WIDGET_CONTROL, ids.showif, SET_VALUE=values

    RETURN

  ENDIF

  ; deassert data reset flag after time delay

  IF KEYWORD_SET(data_reset) THEN data_reset = data_reset - 1

  ; get size of each IF data set

  values = rcs_get_sizes()

  ; check silent flag

  IF rcs_get_silent() THEN RETURN

  ; display start time of last data

  IF KEYWORD_SET(tmax) THEN values.time = anytim2cal(tmax) ELSE values.time=''

  ; get S/C

  values.instrument=(['0:PHOENIX','1:SC FM5/RAP F8', '2:SC FM6/RAP F1', '3:SC FM7/RAP F6', '4:SC FM8/RAP F7','5:RAP F9'])[FIX(rcs_extract_sc())]

  IF WIDGET_INFO(ids.showif,/VALID_ID) THEN WIDGET_CONTROL, ids.showif, SET_VALUE=values

END
