;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_CAL
;
; Purpose     :	Gets pedestal calibration data info for each supplied LUT.
;
; Exlanation  : Gets pedestal calibration data info for each supplied LUT.
;
; Use         : < w = rcs_get_cal (luts) >
;
; Inputs      : luts : LONARR LUT numbers data required for.
;
; Opt. Inputs : None.
;
; Outputs     : w : FLTARR[2,*] 0 = pedestal position in ADC bins
;                               1 = pedetsal FWHM in ADC bins
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/09/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 17/09/00
;-
;**********************************************************

FUNCTION rcs_get_cal, luts

  COMMON local_rcs_get_cal, w, w_file

  ; set up dummy w_file

  IF NOT KEYWORD_SET(w_file) THEN w_file = ''

  ; get current S/C calibration file

  cal_file = rcs_get_cal_name(rcs_extract_sc())

  ; check if already got calibration data

  IF w_file NE cal_file THEN BEGIN

    ; restore calibration data

    pedestals = 0
    lut_map = 0
    temperatures = 0

    RESTORE, cal_file

    ; pedestals = FLTARR(9,256,4,1)
    ; y = FLTARR(nbins,ndetectors)

    ; y = FLTARR(256,4,9)

    y = TRANSPOSE(REFORM(pedestals[*,*,*,0]),[1,2,0])

    ; y = FLTARR(256,4*9)

    y = REFORM(y,256,36)

    w = rcs_fit(y, XMAX=100, /QUIET)

    w_file = cal_file

  ENDIF

  RETURN, w[*,luts]

END
