;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_CAL_NAME
;
; Purpose     :	Returns IES calibration file name.
;
; Explanation : Constructs IES calibration file name using SC number.
;
; Use         : < cal_name = rcs_get_cal_name (sc) >
;
; Inputs      : sc : STRING character giving S/C.
;
; Opt. Inputs : None.
;
; Outputs     : cal_name : calibration file name.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/09/00
;
; Modified    :	Version 0.1, 30/09/03
;                 Used ies get dir.
;
; Version     :	Version 0.1, 30/09/03
;-
;**********************************************************

FUNCTION rcs_get_cal_name, sc

  ; return cal file name

  inst = (['RAP_PH','RAP_F8', 'RAP_F1', 'RAP_F6', 'RAP_F7','RAP_F9'])[FIX(sc)]

  dir = concat_dir(ies_get_dir('CALIBRATION',/RAPID), inst)

  RETURN, concat_dir(dir, 'IES_CALIBRATION')

END
