;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	rcs_get_f1
;
; Purpose     :	Get parameters defining onboard LUT for different times.
;
; Explanation : A time is associated with each set of LUT parameters for each detector and integration time.
;               This represents the time after which the LUT parameters were used.
;
; Use         : < lut_times = rcs_get_f1( p, s, b) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : lut_times : DBLARR(ntimes) TAI times of LUT changes
;               p         : INTARR(9,4,ntimes) pedestal ADC bin position
;               s         : INTARR(9,4,ntimes) pedestal ADC bin FWHM
;               b         : INTARR(8,ntimes) signal energy channels
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/09/00
;
; Modified    :	Version 0.1, 1/2/01
;                 Updated parameters, added delta.
;                 Corrected to 9,4,n output.
;               Version 0.2, 09/07/01
;                 Added version 0.2 LUTS.
;               Version 0.3, 23/05/02
;                 Added test version 0.3 LUTS.
;               Version 0.4, 10/07/02
;                 Added test version of updated 0.3 LUTS.
;               Version 0.5, 15/11/02
;                 Added updated 0.3 LUTS.
;               Version 0.6, 02/12/02
;                 Modified date and time of update of 0.2 LUT parameters.
;                 Previously was 15/May/01 13:00:00.
;                 Changed to     27/May/01 05:35:00
;
; Version     :	Version 0.6, 02/12/02
;-
;**********************************************************

FUNCTION rcs_get_f1, p, s, b

  ; set up table 0.1

  p0 = [ [21,20,19,17], $
         [25,25,24,22], $
         [21,21,20,17], $
         [19,19,18,17], $
         [27,26,26,24], $
         [20,20,19,17], $
         [16,16,14,12], $
         [12,12,11, 9], $
         [15,15,14,12] ]

  s0 = [ [ 3, 3, 4, 6], $
         [ 3, 3, 4, 6], $
         [ 3, 3, 4, 6], $
         [ 3, 3, 4, 6], $
         [ 3, 3, 4, 6], $
         [ 3, 3, 4, 6], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 4], $
         [ 3, 3, 4, 5] ]

  b0 = [21,29,41,56,78,109,151,210]

  ; set up table 0.2

  p1 = [ [22,20,20,18], $
         [26,26,24,22], $
         [22,22,21,18], $
         [20,19,19,16], $
         [27,26,25,23], $
         [20,19,18,16], $
         [17,16,15,13], $
         [13,12,11,10], $
         [15,15,13,12] ]

  s1 = [ [ 4, 5, 5, 7], $
         [ 4, 4, 5, 6], $
         [ 4, 5, 5, 7], $
         [ 4, 5, 5, 7], $
         [ 4, 5, 5, 6], $
         [ 4, 5, 6, 8], $
         [ 4, 5, 5, 6], $
         [ 4, 5, 5, 6], $
         [ 4, 4, 5, 6] ]

  b1 = [20,28,40,55,77,108,150,209]

  ; set up table 0.3

  p2 = [ [22,20,20,18], $
         [26,25,24,22], $
         [23,22,21,18], $
         [20,19,19,16], $
         [27,26,25,24], $
         [21,20,19,17], $
         [16,16,15,13], $
         [13,12,11,10], $
         [16,15,14,12] ]

  s2 = [ [ 4, 5, 5, 7], $
         [ 4, 5, 5, 6], $
         [ 4, 5, 5, 7], $
         [ 4, 5, 5, 7], $
         [ 4, 5, 5, 6], $
         [ 4, 5, 5, 7], $
         [ 4, 5, 5, 6], $
         [ 4, 5, 5, 6], $
         [ 4, 5, 5, 7] ]

  b2 = [20,28,40,55,77,108,150,209]

  ; set up times after which lut valid

  lut_times = anytim2tai(['1/Jan/1990','27/May/2001 05:35:00','23/July/2002 08:10:00'])

  p = INTARR(9,4,N_ELEMENTS(lut_times))
  s = INTARR(9,4,N_ELEMENTS(lut_times))
  b = INTARR(8,N_ELEMENTS(lut_times))

  p[*,*,0] = TRANSPOSE(p0)

  s[*,*,0] = TRANSPOSE(s0)

  b[*,0] = b0

  p[*,*,1] = TRANSPOSE(p1)

  s[*,*,1] = TRANSPOSE(s1)

  b[*,1] = b1

  p[*,*,2] = TRANSPOSE(p2)

  s[*,*,2] = TRANSPOSE(s2)

  b[*,2] = b2

  RETURN, lut_times

END
