;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	rcs_get_f6
;
; Purpose     :	Get parameters defining onboard LUT for different times.
;
; Explanation : A time is associated with each set of LUT parameters for each detector and integration time.
;               This represents the time after which the LUT parameters were used.
;
; Use         : < lut_times = rcs_get_f6( p, s, b) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : lut_times : DBLARR(ntimes) TAI times of LUT changes
;               p         : INTARR(9,4,ntimes) pedestal ADC bin position
;               s         : INTARR(9,4,ntimes) pedestal ADC bin FWHM
;               b         : INTARR(8,ntimes) signal energy channels
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/09/00
;
; Modified    :	Version 0.1, 1/2/01
;                 Updated parameters, added delta.
;                 Corrected to 9,4,n output.
;               Version 0.2, 09/07/01
;                 Added version 0.2 LUTS.
;               Version 0.3, 23/05/02
;                 Added test version 0.3 LUTS.
;               Version 0.4, 15/11/02
;                 Added updated 0.3 LUTS.
;               Version 0.5, 02/12/02
;                 Modified time of LUT 0.2 update.
;                 Was 26/April/2001 16:20:00.
;                 Now 26/April/2001 16:31:00.
;
; Version     :	Version 0.5, 02/12/02
;-
;**********************************************************

FUNCTION rcs_get_f6, p, s, b

  ; set up table 0.1

  p0 = [ [33,33,32,29], $
         [53,53,51,49], $
         [44,43,42,40], $
         [42,42,41,39], $
         [40,40,38,36], $
         [24,23,22,20], $
         [50,49,48,45], $
         [43,42,41,39], $
         [17,17,16,14] ]

  s0 = [ [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5] ]

  b0 = [21,29,41,56,78,109,151,210]

  ; set up table 0.2

  p1 = [ [31,31,30,30], $
         [51,51,50,49], $
         [43,42,41,42], $
         [42,42,40,39], $
         [39,39,37,36], $
         [22,22,22,20], $
         [49,47,47,45], $
         [42,42,40,39], $
         [17,17,15,13] ]

  s1 = [ [ 5, 5, 5, 8], $
         [ 5, 5, 5, 7], $
         [ 4, 5, 5, 9], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 5, 5], $
         [ 5, 5, 5, 6], $
         [ 4, 5, 5, 6], $
         [ 4, 4, 5, 5], $
         [ 4, 4, 5, 6] ]

  b1 = [20,28,40,55,77,108,150,209]

  ; set up table 0.3

  p2 = [ [32,32,31,30], $
         [53,52,51,49], $
         [43,42,41,44], $
         [43,43,42,40], $
         [40,39,37,36], $
         [24,23,22,20], $
         [49,49,48,46], $
         [43,43,42,39], $
         [17,17,16,13] ]

  s2 = [ [ 5, 5, 5, 9], $
         [ 5, 5, 5, 8], $
         [ 4, 5, 5, 9], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 5, 6], $
         [ 5, 5, 5, 7], $
         [ 4, 5, 5, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 5, 7] ]

  b2 = [20,28,40,55,77,108,150,209]

  ; set up times after which lut valid

  lut_times = anytim2tai(['1/Jan/1990','26/Apr/2001 16:31:00','23/July/2002 07:10:00'])

  p = INTARR(9,4,N_ELEMENTS(lut_times))
  s = INTARR(9,4,N_ELEMENTS(lut_times))
  b = INTARR(8,N_ELEMENTS(lut_times))

  p[*,*,0] = TRANSPOSE(p0)

  s[*,*,0] = TRANSPOSE(s0)

  b[*,0] = b0

  p[*,*,1] = TRANSPOSE(p1)

  s[*,*,1] = TRANSPOSE(s1)

  b[*,1] = b1

  p[*,*,2] = TRANSPOSE(p2)

  s[*,*,2] = TRANSPOSE(s2)

  b[*,2] = b2

  RETURN, lut_times

END
