;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	rcs_get_f7
;
; Purpose     :	Get parameters defining onboard LUT for different times.
;
; Explanation : A time is associated with each set of LUT parameters for each detector and integration time.
;               This represents the time after which the LUT parameters were used.
;
; Use         : < lut_times = rcs_get_f7( p, s, b) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : lut_times : DBLARR(ntimes) TAI times of LUT changes
;               p         : INTARR(9,4,ntimes) pedestal ADC bin position
;               s         : INTARR(9,4,ntimes) pedestal ADC bin FWHM
;               b         : INTARR(8,ntimes) signal energy channels
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/09/00
;
; Modified    :	Version 0.1, 1/2/01
;                 Updated parameters, added delta.
;                 Corrected to 9,4,n output.
;               Version 0.2, 09/07/01
;                 Added version 0.2 LUTS.
;               Version 0.3, 23/05/02
;                 Added test version 0.3 LUTS.
;               Version 0.4, 15/11/02
;                 Added updated 0.3 LUTS.
;
; Version     :	Version 0.4, 15/11/02
;-
;**********************************************************

FUNCTION rcs_get_f7, p, s, b

  ; set up table 0.1

  p0 = [ [15,15,13,12], $
         [24,24,23,20], $
         [25,25,23,21], $
         [35,35,34,31], $
         [18,18,17,15], $
         [23,24,22,20], $
         [15,16,14,12], $
         [33,33,32,30], $
         [34,34,33,30] ]

  s0 = [ [ 3, 4, 4, 5], $
         [ 3, 4, 4, 5], $
         [ 3, 4, 4, 6], $
         [ 3, 4, 5, 7], $
         [ 3, 4, 4, 5], $
         [ 3, 4, 5, 8], $
         [ 3, 4, 6, 5], $
         [ 3, 4, 4, 6], $
         [ 3, 4, 5, 8] ]

  b0 = [21,29,41,56,78,109,151,210]

  ; set up table 0.2

  p1 = [ [15,14,14,11], $
         [24,25,23,20], $
         [26,26,24,21], $
         [36,34,34,32], $
         [17,17,17,16], $
         [24,23,22,19], $
         [15,16,15,17], $
         [33,33,33,31], $
         [35,35,32,30] ]

  s1 = [ [ 5, 5, 5, 6], $
         [ 5, 4, 5, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 5, 5, 6], $
         [ 5, 5, 5, 5], $
         [ 4, 5, 5, 7], $
         [ 5, 5, 6, 8], $
         [ 5, 5, 5, 6], $
         [ 4, 4, 6, 7] ]

  b1 = [20,28,40,55,77,108,150,209]

  ; set up table 0.3

  p2 = [ [16,16,14,11], $
         [25,25,23,20], $
         [26,26,24,21], $
         [36,36,34,32], $
         [18,18,17,15], $
         [23,23,22,20], $
         [15,16,15,17], $
         [34,34,33,31], $
         [35,35,33,30] ]

  s2 = [ [ 5, 5, 5, 7], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 5, 5, 7], $
         [ 4, 4, 5, 6], $
         [ 4, 5, 5, 7], $
         [ 5, 5, 6, 8], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 6, 7] ]

  b2 = [20,28,40,55,77,108,150,209]

  ; set up times after which lut valid

  lut_times = anytim2tai(['1/Jan/1990','18/May/2001 07:45:00','30/July/2002 07:15:00'])

  p = INTARR(9,4,N_ELEMENTS(lut_times))
  s = INTARR(9,4,N_ELEMENTS(lut_times))
  b = INTARR(8,N_ELEMENTS(lut_times))

  p[*,*,0] = TRANSPOSE(p0)
  s[*,*,0] = TRANSPOSE(s0)
  b[*,0] = b0

  p[*,*,1] = TRANSPOSE(p1)
  s[*,*,1] = TRANSPOSE(s1)
  b[*,1] = b1

  p[*,*,2] = TRANSPOSE(p2)
  s[*,*,2] = TRANSPOSE(s2)
  b[*,2] = b2

  RETURN, lut_times

END
