;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	rcs_get_f8
;
; Purpose     :	Get parameters defining onboard LUT for different times.
;
; Explanation : A time is associated with each set of LUT parameters for each detector and integration time.
;               This represents the time after which the LUT parameters were used.
;
; Use         : < lut_times = rcs_get_f8( p, s, b) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : lut_times : DBLARR(ntimes) TAI times of LUT changes
;               p         : INTARR(9,4,ntimes) pedestal ADC bin position
;               s         : INTARR(9,4,ntimes) pedestal ADC bin FWHM
;               b         : INTARR(8,ntimes) signal energy channels
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/09/00
;
; Modified    :	Version 0.1, 1/2/01
;                 Updated parameters, added delta.
;                 Corrected to 9,4,n output.
;               Version 0.2, 09/07/01
;                 Added version 0.2 LUTS.
;               Version 0.3, 23/05/02
;                 Added test version 0.3 LUTS.
;               Version 0.4, 15/11/02
;                 Added updated 0.3 LUTS.
;
; Version     :	Version 0.4, 15/11/02
;-
;**********************************************************

FUNCTION rcs_get_f8, p, s, b

  ; set up table 0.1

  p0 = [ [62,61,60,57], $
         [27,27,26,23], $
         [33,32,31,28], $
         [40,39,38,35], $
         [29,28,27,24], $
         [36,35,34,31], $
         [18,16,15,12], $
         [45,44,43,40], $
         [34,34,33,30] ]

  s0 = [ [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5] ]

  b0 = [21,29,41,56,78,109,151,192]

  ; set up table 0.2

  p1 = [ [61,61,59,57], $
         [28,27,27,23], $
         [33,33,31,29], $
         [40,39,37,36], $
         [28,27,27,25], $
         [37,36,34,32], $
         [19,17,15,12], $
         [45,44,42,40], $
         [34,34,32,30] ]

  s1 = [ [ 4, 4, 5, 6], $
         [ 4, 4, 4, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 4, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 5, 7], $
         [ 4, 4, 5, 6], $
         [ 5, 5, 6, 7] ]

  b1 = [20,28,40,55,77,108,150,209]

  ; set up table 0.3

  p2 = [ [62,61,60,57], $
         [28,28,27,25], $
         [33,33,31,29], $
         [40,40,39,36], $
         [28,28,27,25], $
         [37,36,34,32], $
         [19,17,16,14], $
         [45,44,43,41], $
         [35,35,34,32] ]

  s2 = [ [ 4, 4, 5, 6], $
         [ 4, 4, 4, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 4, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 5, 6], $
         [ 4, 4, 5, 6] ]

  b2 = [20,28,40,55,77,108,150,209]

  ; set up times after which lut valid

  lut_times = anytim2tai(['1/Jan/1990','18/May/2001 09:30:00','25/July/2002 07:52:00'])

  p = INTARR(9,4,N_ELEMENTS(lut_times))
  s = INTARR(9,4,N_ELEMENTS(lut_times))
  b = INTARR(8,N_ELEMENTS(lut_times))

  p[*,*,0] = TRANSPOSE(p0)
  s[*,*,0] = TRANSPOSE(s0)
  b[*,0] = b0

  p[*,*,1] = TRANSPOSE(p1)
  s[*,*,1] = TRANSPOSE(s1)
  b[*,1] = b1

  p[*,*,2] = TRANSPOSE(p2)
  s[*,*,2] = TRANSPOSE(s2)
  b[*,2] = b2

  RETURN, lut_times

END
