;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	rcs_get_f9
;
; Purpose     :	Get parameters defining onboard LUT for different times.
;
; Explanation : A time is associated with each set of LUT parameters for each detector and integration time.
;               This represents the time after which the LUT parameters were used.
;
; Use         : < lut_times = rcs_get_f9( p, s, b) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : lut_times : DBLARR(ntimes) TAI times of LUT changes
;               p         : INTARR(9,4,ntimes) pedestal ADC bin position
;               s         : INTARR(9,4,ntimes) pedestal ADC bin FWHM
;               b         : INTARR(8,ntimes) signal energy channels
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/09/00
;
; Modified    :	Version 0.1, 1/2/01
;                 Added delta.
;                 Corrected to 9,4,n output.
;
; Version     :	Version 0.1, 1/2/01
;-
;**********************************************************

FUNCTION rcs_get_f9, p, s, b

  ; set up table 0

  p0 = [ [33,33,31,28], $
         [49,48,47,45], $
         [23,23,22,19], $
         [35,35,34,31], $
         [17,17,16,14], $
         [43,43,42,39], $
         [18,18,17,14], $
         [47,47,46,44], $
         [30,30,29,26] ]

  s0 = [ [ 3, 3, 4, 7], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5], $
         [ 3, 3, 4, 5] ]

  delta0 = [8, 12, 15, 22, 31, 42, 41]

  b0 = INTARR(8)
  b0[0] = 21
  FOR k = 1, 7 DO b0[k] = b0[k-1]+delta0[k-1]

  ; set up times after which lut valid

  lut_times = anytim2tai(['1/Jan/1990'])

  ; set up return values

  p = INTARR(9,4,N_ELEMENTS(lut_times))
  s = INTARR(9,4,N_ELEMENTS(lut_times))
  b = INTARR(8,N_ELEMENTS(lut_times))

  p[*,*,0] = TRANSPOSE(p0)
  s[*,*,0] = TRANSPOSE(s0)
  b[*,0] = b0

  RETURN, lut_times

END
