;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_HK_EDBS
;
; Purpose     :	Extracts EDBs from NM EDB data stream.
;
; Explanation : checks subcommutation indices are consecutive
;
; Use         : < RCS_GET_HK_EDBS, ids >
;
; Inputs      : ids : STRUCTURE containing widget info
;
; Opt. Inputs : None.
;
; Outputs     : 0 : no EDBs found
;               1 : found EDBs
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : rcs_adjust_common, rcs_get_ccsnm_sync
;
; Common      : ccsnm_data_block, ccsnm_edb_block
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	Version 0.1, 12/2/01
;                 Moved previous to common block.
;                 Moved RESET.
;
; Version     :	Version 0.1, 12/2/01
;-
;**********************************************************

PRO rcs_get_hk_edbs, ids

  ; global COMMON blocks
  ; data : BYTARR
  ; headers : STRUCTURE array

  COMMON rcshk_data_block, data, headers

  ; check if any data yet

  IF NOT KEYWORD_SET(data) THEN RETURN

  ; get previous info

  previous = rcs_get_previous(/HK)

  ; get packets

  IF (N_ELEMENTS(data) MOD 40) NE 0 THEN rcs_message, 'HK SYNC LOST'

  nmarkers = N_ELEMENTS(data)/40

  markers = LINDGEN(nmarkers)*40

  ; extract hk data

  rcs_extract_hk, ids, headers, data, markers, nmarkers, previous

  ; remove input data from COMMON block

  data = 0
  headers = 0

  ; update previous

  rcs_set_previous, previous, /HK

  RETURN

END
