;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_IFNAMES
;
; Purpose     :	Gets names of all IF files for given day and S/C.
;
; Explanation : Gets names of all IF files for given day and S/C.
;
; Use         : < ifnames = rcs_get_ifnames(sc,day) >
;
; Inputs      : sc   : STRING character giving SC for processing.
;               day  : STRING if day
;
; Opt. Inputs : None.
;
; Outputs     : ifnames : STRARR all IF files with same date.
;
; Opt. Outputs: None.
;
; Keywords    : COUNT : INT returns no. of if files
;
; Written     :	Version 0.0, 16/03/01
;
; Modified    : Version 0.1, 22/03/01
;                 Modified to use rcs_get_iffiles.
;               Version 0.2, 18/07/01
;                 Added argument sc to argument list. Can only process files from a single directory anyway.
;                 Replaced argument file with day.
;               Version 0.3, 03/09/03
;                 Changed default behaviour of rcs_get_iffiles.
;
; Version     :	Version 0.3, 03/09/03
;-
;**********************************************************

FUNCTION rcs_get_ifnames, sc, day, COUNT=ifcount

  ; get ifnames

  ifnames = rcs_get_iffiles ( sc, COUNT=ifcount, DAY=day )

  IF ifcount EQ 0 THEN RETURN, ''

  ; sort so that latest versions are last

  ifnames = ifnames[SORT(ifnames)]

  ; strip out paths and names

  names = strip_dirname(ifnames, PATH=paths)

  ; get unique paths

  ifnames = ifnames[UNIQ(paths)]

  ifcount = N_ELEMENTS(ifnames)

  ; return

  RETURN, ifnames

END
