;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_INDEX
;
; Purpose     :	Returns header indices corresponding to marker positions.
;               Each header contains a data index corresponding to the
;               size of the data array when the header was encountered.
;               The header at or before each data marker is found by searching through
;               the header data indices.
;               An array of header indices is returned.
;
; Use         : < indices = RCS_GET_INDEX ( lll0, count, headers) >
;
;
; Inputs      : lll0 : LONARR(count) markers into data array.
;               count : LONG no. of markers. Always > 0.
;               headers : STRUCTURE array containing header info.
;
; Opt. Inputs : None.
;
; Outputs     : indices : LONARR indices of headers corresponding to markers
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************


FUNCTION rcs_get_index, lll0, count, headers

  ; set up output array

  indices = LONARR(count)

  ; loop through markers finding which header they belong to

  pos = 0 ; position in header array

  FOR k = 0, count-1 DO BEGIN

    IF pos EQ N_ELEMENTS(headers)-1 THEN GOTO, exitloop

    WHILE lll0[k] GE headers[pos+1].index DO BEGIN

      pos = pos + 1

      IF pos EQ N_ELEMENTS(headers)-1 THEN GOTO, exitloop

    ENDWHILE

    exitloop :

    indices[k] = pos

  ENDFOR

  RETURN, indices

END