;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_MVALS
;
; Purpose     :	Extracts MVALS data from BM or NM EDB.
;
; Use         : < mvals = rcs_get_mvals(edb, epad_table ) >
;
; Inputs      : edb        : BYTARR EDB packet
;               epad_table : BYTE FLAG indicating epad table A (0) or B (1)
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : BM : FLAG indictaing BM.
;
; Written     :	Version 0.0, 23/07/02
;
; Modified    :
;
; Version     :	Version 0.0, 23/07/02
;-
;**********************************************************

FUNCTION rcs_get_mvals, edb, epad_table, BM=bm

  ; extract m

  IF KEYWORD_SET(bm) THEN m = edb['8F8'X:'8F8'X+8-1] ELSE m = edb['1F8'X:'1F8'X+8-1]

  ; extract m signs
  ; NB ordered as byte0 = sectors 7-0, byte1 = sectors 15-8

  msigns = edb['007'X:'007'X+2-1]

  ; set up mvals array

  mvals = [m, msigns, epad_table]

  RETURN, mvals

END
