;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_SC_EDBS
;
; Purpose     :	Extracts EDBs from NM EDB data stream.
;
; Explanation : checks subcommutation indices are consecutive
;
; Use         : < RCS_GET_SC_EDBS, ids >
;
; Inputs      : ids : STRUCTURE containing widget info
;
; Opt. Inputs : None.
;
; Outputs     : 0 : no EDBs found
;               1 : found EDBs
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : rcs_adjust_common, rcs_get_ccsnm_sync
;
; Common      : ccsnm_data_block, ccsnm_edb_block
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	Version 0.1, 12/2/01
;                 Moved previous to common block.
;                 Moved RESET.
;               Version 0.2, 22/05/02
;                 Corrected bug when previous.pos LT 0 and marker not processed.
;
; Version     :	Version 0.2, 22/05/02
;-
;**********************************************************

PRO rcs_get_sc_edbs, ids

  ; global COMMON blocks
  ; data : BYTARR
  ; headers : STRUCTURE array

  COMMON rcssc_data_block, data, headers

  ; check if any data yet

  IF NOT KEYWORD_SET(data) THEN RETURN

  ; get previous info
  ; previous is a structure : {subc,type,pos}, containing information about the previous edb
  ; previous.pos gives the end point of data processed so far in the data array

  previous = rcs_get_previous(/SC)

  ; find NM/BM sync markers
  ; NB returns possible markers in the last two bytes

  markers = rcs_get_sync(data, COUNT=nmarkers)

  ; if no sync remove data and times and RETURN
  ; let problem of why no sync be dealt with once sync found
  ; keep track of amount of data thrown away in previous_pos

  IF nmarkers EQ 0 THEN BEGIN

    ; adjust previous pos

    previous.pos = previous.pos - N_ELEMENTS(data)

    ; remove input data from COMMON block

    rcs_adjust_common, N_ELEMENTS(data), data, headers

    rcs_set_previous, previous, /SC

    RETURN

  ENDIF

  ; get header indices corresponding to markers

  indices = rcs_get_index ( markers, nmarkers, headers)

  ; extract edb data

  rcs_extract_edb, ids, data, headers, markers, indices, nmarkers, previous

  ; possible that previous.pos not updated if only one marker and within 3 bytes of end
  ; possible that previous.pos was less than 0 and was updated to 0
  ; not possible that previous.pos was less than 0 and was changed and is still less than 0

  IF previous.pos GE 0 THEN BEGIN

    ; remove input data from COMMON block

    rcs_adjust_common, previous.pos, data, headers

    ; adjust previous pos

    previous.pos = 0

    ; update previous

    rcs_set_previous, previous, /SC

  ENDIF ELSE BEGIN

    PRINT, 'MISSED'

  ENDELSE

END
