;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_SIZES
;
; Purpose     :	Returns no of samples in each IF data set and total size in bytes.

; Explanation : Returns structure giving no of samples in each IF data set and total size in bytes.
;
; Use         : < sizes = rcs_get_sizes(HK=hk) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : sizes : STRUCTURE giving no of sample sin each IF data set, total size in bytes
;
; Opt. Outputs: None.
;
; Keywords    : HK : Flag indicating reduced structure for HK data only.
;
; Written     :	Version 0.0, 17/09/00
;
; Modified    : Version 0.1, 6/2/01
;                 Added pedestals and espct IF data set.
;               Version 0.2, 15/05/01
;                 Added CLEANBM2.
;               Version 0.3, 25/05/01
;                 Added things to HK1 and HK32.
;               Version 0.4, 07/02/02
;                 Added EPAD2.
;
; Version     :	Version 0.4, 07/02/02
;-
;**********************************************************

FUNCTION rcs_get_sizes, HK=hk

  ; global common blocks

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  IF KEYWORD_SET(hk) THEN BEGIN

    values = {ehk:0L, hk1:0L, hk2:0L, hk4:0L, hk8:0L, hk32:0L, time:''}

    IF KEYWORD_SET(ehk_header) THEN values.ehk = ehk_header.npoints

    IF KEYWORD_SET(hk1_header) THEN values.hk1 = hk1_header.npoints

    IF KEYWORD_SET(hk2_header) THEN values.hk2 = hk2_header.npoints

    IF KEYWORD_SET(hk4_header) THEN values.hk4 = hk4_header.npoints

    IF KEYWORD_SET(hk8_header) THEN values.hk8 = hk8_header.npoints

    IF KEYWORD_SET(hk32_header) THEN values.hk32 = hk32_header.npoints

    RETURN, values

  ENDIF

  values = {e3dd:0L, clean:0L, e3ddbm:0L, cleanbm:0L, cleanbm2:0L, espct:0L, pedestal:0L, ehist:0L, ehk:0L, epad:0L, epad2:0L, i3dd:0L, ipad:0L, ispct:0L, hspct:0L, mtrx:0L, $
            sglbm:0L, sgl01:0L, sgl2:0L, sgl3:0L, hk1:0L, hk2:0L, hk4:0L, hk8:0L, hk32:0L, scinfo:0L, time:'', instrument:'', ifsize:0L }

  IF KEYWORD_SET(e3ddnm_header) THEN values.e3dd = e3ddnm_header.npoints

  IF KEYWORD_SET(clean_header) THEN values.clean = clean_header.npoints

  IF KEYWORD_SET(e3ddbm_header) THEN values.e3ddbm = e3ddbm_header.npoints

  IF KEYWORD_SET(cleanbm_header) THEN values.cleanbm = cleanbm_header.npoints

  IF KEYWORD_SET(cleanbm2_header) THEN values.cleanbm2 = cleanbm2_header.npoints

  IF KEYWORD_SET(espct_header) THEN values.espct = espct_header.npoints

  IF KEYWORD_SET(pedestal_header) THEN values.pedestal = pedestal_header.npoints

  IF KEYWORD_SET(epad_header) THEN values.epad = epad_header.npoints

  ; NB epad2 has nsectors expanded onto timeline

  IF KEYWORD_SET(epad2_header) THEN values.epad2 = epad2_header.npoints

  IF KEYWORD_SET(ehist_header) THEN values.ehist = ehist_header.npoints

  IF KEYWORD_SET(ehk_header) THEN values.ehk = ehk_header.npoints

  IF KEYWORD_SET(i3dd_header_H) THEN values.i3dd = i3dd_header_H.npoints

  IF KEYWORD_SET(ipad_header) THEN values.ipad = ipad_header.npoints

  IF KEYWORD_SET(hspct_header) THEN values.hspct = hspct_header.npoints

  IF KEYWORD_SET(ispct_header_He) THEN values.ispct = ispct_header_He.npoints

  IF KEYWORD_SET(mtrx_header) THEN values.mtrx = mtrx_header.npoints

  IF KEYWORD_SET(sglbm_header) THEN values.sglbm = sglbm_header.npoints

  IF KEYWORD_SET(sgl01_header) THEN values.sgl01 = sgl01_header.npoints

  IF KEYWORD_SET(sgl2_header) THEN values.sgl2 = sgl2_header.npoints

  IF KEYWORD_SET(sgl3_header) THEN values.sgl3 = sgl3_header.npoints

  IF KEYWORD_SET(hk1_header) THEN values.hk1 = hk1_header.npoints

  IF KEYWORD_SET(hk2_header) THEN values.hk2 = hk2_header.npoints

  IF KEYWORD_SET(hk4_header) THEN values.hk4 = hk4_header.npoints

  IF KEYWORD_SET(hk8_header) THEN values.hk8 = hk8_header.npoints

  IF KEYWORD_SET(hk32_header) THEN values.hk32 = hk32_header.npoints

  IF KEYWORD_SET(scinfo_header) THEN values.scinfo = scinfo_header.npoints

  ; calculate total size of IF data in bytes

  values.ifsize = values.e3dd*4L*(9*8+6) + values.clean*4L*(9*6+6)  + values.espct*4L*(6+6) + values.e3ddbm*4L*(16*9*12+6) + values.cleanbm*4L*(16*9*8+6) $
                + values.cleanbm2*4L*(16*9*1+6) + values.pedestal*4L*(5+6) + values.ehist*4L*(256+6) + values.ehk*4L*(9*4+6) $
               + values.epad*(4L*((16*9*2)+6)+11) + values.epad2*(4L*((3*2)+6)+3) + values.i3dd*3*4L*(16*12*8+6) + values.ipad*(4L*(16*12*2+6)+11) $
               + values.ispct*2*4L*(8+6) + values.hspct*4L*(8+6) + values.mtrx*4L*(32*64+6) + values.sglbm*4L*(5+6)+ values.sgl01*4L*(7+6) $
               + values.sgl2*4L*(18+6) + values.sgl3*4L*(22+6) + values.hk1*4L*(12+6) + values.hk8*4L*(8+6)  + values.hk32*4L*(5+6) + values.scinfo*4L*(2+6)

  RETURN, values

END
