;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_SUBDIR
;
; Purpose     :	Sets up sub-directory structure.
;
; Explanation : The directory structure has format 'rootdir\scdir\type\index'.
;               If sc not set then returns 'rootdir'.
;               If type not set then returns 'rootdir\scdir'.
;               If index not set then returns 'rootdir\scdir\type'.
;               Attempts to create subdirectories under rootdir if do not exist.
;               Returns '' if unsuccessful.
;
; Use         : < dir = RCS_GET_SUBDIR(root, sc, type, index) >
;
; Inputs      : root   : STRING defining root directory ie 'IF'
;
; Opt. Inputs : sc     : STRING character giving S/C or ''
;               type   : STRING IF data type
;               index  : STRING giving index sub-directory
;
; Outputs     : dir    : STRING directory name
;                        Returns '' if unsuccessful.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;;
; Written     :	Version 0.0, 14/06/01
;;
; Modified    : Version 0.1, 08/10/03
;                 Used ies get dir.
;               Version 0.2, 07/11/03
;                 Added root and index arguments to generalize.
;                 Renamed from rcs get ifdir.
;                 Added index sub-directory.
;                 Try to create root directory if not present.
;
; Version     :	Version 0.2, 07/11/03
;-
;**********************************************************

FUNCTION rcs_get_subdir, root, sc, type, index

  ; get root directory

  dir = ies_get_dir(root,/RAPID)

  IF NOT rcs_dir_exist(dir,/CREATE) THEN BEGIN
    rcs_message, root + ' directory does not exist : ' + dir, /INFORMATIONAL
    RETURN, ''
  ENDIF

  IF N_ELEMENTS(sc) EQ 0 THEN RETURN, dir

  ; get sc directory

  dir = concat_dir(dir,rcs_get_scname(sc))

  IF NOT rcs_dir_exist(dir,/CREATE) THEN BEGIN
    rcs_message, root + ' sub-directory does not exist : ' + dir, /INFORMATIONAL
    RETURN, ''
  ENDIF

  IF N_ELEMENTS(type) EQ 0 THEN RETURN, dir

  ; get type directory

  dir = rcs_strtrim(concat_dir(dir,type))

  IF NOT rcs_dir_exist(dir,/CREATE) THEN BEGIN
    rcs_message, root + ' sub-directory does not exist : ' + dir, /INFORMATIONAL
    RETURN, ''
  ENDIF

  IF N_ELEMENTS(index) EQ 0 THEN RETURN, dir

  ; get index directory

  dir = concat_dir(dir,index)

  IF NOT rcs_dir_exist(dir,/CREATE) THEN BEGIN
    rcs_message, root + ' sub-directory does not exist : ' + dir, /INFORMATIONAL
    RETURN, ''
  ENDIF

  RETURN, dir

END
