;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_SYNC
;
; Purpose     :	Returns positions of sync markers '146f2e'
;               If sync markers overlap data boundary then  returns possible sync.
;
; Use         : < result = RCS_GET_CCSNM_SYNC(data) >
;
; Inputs      : data : BYTARR CCSNM EDB data stream.
;
; Opt. Inputs : None.
;
; Outputs     : result : LONARR indices of sync markers encountered or -1 if none
;
; Opt. Outputs: None.
;
; Keywords    : COUNT : INT returns no. of markers found.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	Version 0.1, 4/4/01
;                 Allowed for situation in which sync markers span data boundary.
;                 Note this was previously a bug -- IDL does not complain about array[[index]]
;                 if index is out of range.
;               Version 0.2, 3/5/01
;                 Fixed bug where count not defined.
;
; Version     :	Version 0.2, 3/5/01
;-
;**********************************************************

FUNCTION rcs_get_sync, data, COUNT=count

  ; ensure count defined

  count = 0

  ; find first sync markers
  ; this is inefficient since know where markers will be mostly

  ndata = N_ELEMENTS(data)

  IF ndata GT 2 THEN BEGIN

    l0 = WHERE (data[0:ndata-3] EQ '14'X, count)

    IF count GT 0 THEN BEGIN

      ; find second sync markers

      l1 = WHERE (data[l0+1] EQ '6f'X, count)

      IF count GT 0 THEN BEGIN

        ; index back to data

        ll0 = l0[l1]

        ; find NM/BM2/BM1/BM3 3rd sync markers

        l2 = WHERE (data[ll0+2] EQ '2e'X OR data[ll0+2] EQ '3d'X OR data[ll0+2] EQ '8b'X, count)

        ; get sync marker position indexed to data

        IF count GT 0 THEN lll0 = ll0[l2]

      ENDIF

    ENDIF

  ENDIF

  ; process last two bytes

  IF ndata GE 2 THEN BEGIN

    IF (data[ndata-2] EQ '14'X AND data[ndata-1] EQ '6f'X) THEN BEGIN

      xtra = ndata-2

    ENDIF

  ENDIF

  IF data[ndata-1] EQ '14'X THEN BEGIN

    xtra = ndata-1

  ENDIF

  ; if any sync marker in last 2 bytes add to list

  IF N_ELEMENTS(xtra) NE 0 THEN BEGIN

    IF count EQ 0 THEN BEGIN

      count = 1

      lll0 = [xtra]

    ENDIF ELSE BEGIN

      count = count + 1

      lll0 = [lll0,xtra]

    ENDELSE

  ENDIF

  ; return sync marker position indexed to data

  IF count GT 0 THEN RETURN, lll0 ELSE RETURN,-1

END