;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_TYPE
;
; Purpose     :	Returns position of first set of sync markers '146f2e'
;
; Use         : < result = RCS_GET_CCSNM_SYNC(data) >
;
; Inputs      : data : BYTARR CCSNM EDB data stream.
;
; Opt. Inputs : None.
;
; Outputs     : result : LONARR indices of sync markers encountered or -1 if none
;
; Opt. Outputs: None.
;
; Keywords    : COUNT : INT returns no. of markers found.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

FUNCTION rcs_get_type, sync, header

  ; Use type
  ;     0 : NM
  ;     1 : BM1
  ;     2 : BM2
  ;     3 : BM3

  ; header.header.info.type can be 'CCSNM', 'CCSBM' for DDS data
  ; or 'CCSNM', 'CCSBM1/2/3' for GSEOS data

  ; have found GSEOS data with
  ;  NM/BM2 data in CCSBM1
  ;  BM1 data in CCSNM
  ; these occurred at the switch over
  ; do they contain valid data ?

  IF sync EQ '2e'X THEN BEGIN

    IF header.header.info.type EQ 'CCSNM' THEN type = 0 ELSE type = 2

  ENDIF ELSE IF sync EQ '3d'X THEN BEGIN

    type = 1

  ENDIF ELSE IF sync EQ '8b'X THEN BEGIN

    type = 3

  ENDIF ELSE rcs_message, 'INVALID type'

  RETURN, type

END