;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_USE
;
; Purpose     :	Gets USE IF.
;
; Explanation : Gets USE IF.
;
; Use         : < use =  rcs_get_use() >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : use : STRUCTURE containing USE info.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 11/2/01
;
; Modified    : Version 0.1, 15/05/01
;                 Added cleanbm2 IF data set.
;               Version 0.2, 27/07/01
;                 Protected output.
;               Version 0.3, 08/02/02
;                 Added EPAD2.
;
; Version     :	Version 0.3, 08/02/02
;-
;**********************************************************

FUNCTION rcs_get_use

  COMMON rcs_use_local, use

  ; set up count

  IF NOT KEYWORD_SET(use) THEN $
    use = {e3dd:1, clean:1, e3ddbm:1, cleanbm:1, cleanbm2:1, espct:1, pedestal:1, ehist:1, $
           ehk:1, epad:1, epad2:1, i3dd:1, ipad:1, ispct:1, hspct:1, mtrx:1, $
           sglbm:1, sgl01:1, sgl2:1, sgl3:1, hk1:1, hk2:1, hk4:1, hk8:1, hk32:1, scinfo:1}

  temp = use

  RETURN, temp

END
