;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_HK_INFO
;
; Purpose     :	Returns position of first set of sync markers '146f2e'
;
; Use         : < result = RCS_GET_CCSNM_SYNC(data) >
;
; Inputs      : data : BYTARR CCSNM EDB data stream.
;
; Opt. Inputs : None.
;
; Outputs     : result : LONARR indices of sync markers encountered or -1 if none
;
; Opt. Outputs: None.
;
; Keywords    : COUNT : INT returns no. of markers found.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	Version 0.1, 14/03/01
;                 Removed ids from rcs_text and this argument list.
;
; Version     :	Version 0.1, 14/03/01
;-
;**********************************************************

PRO rcs_hk_info, current_header, current_fc, previous_fc

  rcs_text, '  CURRENT HK FILE : ' + current_header.header.info.name
  rcs_text, '  CURRENT HK FRAME COUNTER  : ' + rcs_strtrim(FIX(current_fc))
  rcs_text, '  CURRENT HK HEADER TIME : ' + anytim2cal(current_header.header.time)

END