;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_HV_CAL
;
; Purpose     :	Returns calibrated HV given HK ADC value.
;
; Explanation : Returns calibrated HV given HK ADC value.
;
; Use         : < rcs_hv_cal, ERISTAHV=eristahv, ERISTOHV=eristohv, ERIDEFHV=eridefhv  >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : ERISTAHV : On input contains BYTE ADC value, on output contains FLOAT calibrated HV.
;               ERISTOHV : On input contains BYTE ADC value, on output contains FLOAT calibrated HV.
;               ERIDEFHV : On input contains BYTE ADC value, on output contains FLOAT calibrated HV.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 17/9/00
;-
;**********************************************************

PRO rcs_hv_cal, ERISTAHV=eristahv, ERISTOHV=eristohv, ERIDEFHV=eridefhv

  COMMON rcs_hv_local_block, eristahv_cal, eristohv_cal, eridefhv_cal

  IF N_ELEMENTS(eristahv_cal) EQ 0 THEN BEGIN

  ; set up cal arrays

  eristahv_cal = INTARR(2,20)

  eristohv_cal = INTARR(2,20)

  eridefhv_cal = INTARR(2,20)

  ; calibrate data
  ; no variation between s/c

eristahv_cal[*,*] = $
[[0,0],[127,0],[128,26],[130,132],[132,237],[156,1504],[158,1610],[184,2992],$
[186,3087],[188,3193],[190,3298],[192,3404],[194,3509],[196,3615],[198,3720],$
[200,3826],[202,3931],[204,4037],[208,4248],[255,6728]]

eristohv_cal[*,*] = $
[[0,0],[127,0],[128,26],[130,132],[132,237],[156,1504],[158,1610],[184,2982],$
[186,3087],[188,3193],[190,3298],[192,3404],[194,3509],[196,3615],[198,3720],$
[200,3826],[202,3931],[204,4037],[208,4248],[255,6728]]

eridefhv_cal[*,*] = $
[[0,0],[127,0],[128,47],[130,233],[134,420],[137,700],[143,1448],[150,2101], $
[158,2849],[165,3502],[173,4250],[180,4903],[187,5557],[195,6304],[202,6958],$
[210,7705],[228,9386],[237,10227],[244,10881],[255,11908]]

  ENDIF

  IF KEYWORD_SET(eristahv) THEN eristahv = INTERPOL(eristahv_cal[1,*],eristahv_cal[0,*],eristahv)

  IF KEYWORD_SET(eristohv) THEN eristohv = INTERPOL(eristohv_cal[1,*],eristohv_cal[0,*],eristohv)

  IF KEYWORD_SET(eridefhv) THEN eridefhv = INTERPOL(eridefhv_cal[1,*],eridefhv_cal[0,*],eridefhv)

END
