;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IF_FILTER
;
; Purpose     :	Constructs filter for IF data set.
;
; Explanation : Constructs filter for IF data set.
;
; Use         : < filter = rcs_if_filter(sc_root, datatype, DAY=day, SOURCE=source, CD_VERSION=cd_version, SW_VERSION=sw_version) >
;
; Inputs      : None.
;
; Opt. Inputs : sc_root  : STRING giving SC root directory ie 'RAPID_1'
;               datatype : STRING giving data type ie 'IES_ESPCT'
;
; Outputs     : filter   : STRING IF filename filter
;
; Opt. Outputs: None.
;
; Keywords    : DAY        : STRING giving day ie 'yymmdd'
;               SOURCE     : STRING source filter ie 'sci'
;               CD_VERSION : STRING cd version ie 'a'
;               SW_VERSION : STRING sw version ie '2_3'
;               VERSION    : STRING version ie 'sss_v_a_b'
;
; Written     :	Version 0.0, 02/09/03
;
; Modified    : Version 0.1, 04/09/03
;                 Added VERSION keyword.
;               Version 0.2, 08/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.2, 08/10/03
;-
;**********************************************************

FUNCTION rcs_if_filter, sc_root, datatype, DAY=day, SOURCE=source, CD_VERSION=cd_version, SW_VERSION=sw_version, VERSION=version

  ; set up defaults
  ; allow day = '', source = '', cd_version = '', sw_version = '' to bypass defaults

  IF N_ELEMENTS(day) EQ 0 THEN day = '*'

  ; set up filter
  ; allow yymmdd.dat searches and multiple days

  IF N_ELEMENTS(sc_root) GT 0 THEN BEGIN

    filter = concat_dir(ies_get_dir('IF',/RAPID),sc_root)

    filter = concat_dir(filter,datatype)

    filter = concat_dir(filter,day[0])

  ENDIF ELSE filter = day[0]

  IF NOT KEYWORD_SET(version) THEN version = rcs_if_version ( SOURCE=source, CD_VERSION=cd_version, SW_VERSION=sw_version)

  ; if version is '' then return root\*.dat or root\yymmdd.dat
  ; if version is '*' then return root\*.dat or root\yymmdd*.dat
  ; else return root\*_version.dat or root\yymmdd_version.dat

  IF version EQ '' THEN filter = filter + '.dat' ELSE $
  IF version EQ '*' AND day[0] EQ '*' THEN filter = filter + '.dat' ELSE $
  IF version EQ '*' THEN filter = filter + '*.dat' ELSE $
  filter = filter + '_' + version + '.dat'

  RETURN, filter

END
