;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IF_VERSION
;
; Purpose     :	Constructs IF version string.
;
; Explanation : Constructs IF version string.
;               Used in creating IF file name and version string in IF header.
;               Also used to create IF file filter.
;               Version has format 'sss_v_a_b' where sss is source string, v is CDROM version and
;               a_b is SW version.
;               For compatability with naming convention yymmdd.dat want to be able to specify version = ''
;               This is achieved by source = '', cd_version = '', sw_version = ''.
;               For compatability with naming convention yymmddsva_b.dat want to be able to specify
;               version ='*'.
;               This is achieved by source = undefined or '*', cd_version = undefined or '* and
;               sw_version = undefined or '*'
;
; Use         : < version = rcs_if_version(SOURCE=source, CD_VERSION=cd_version, SW_VERSION=sw_version) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : version   : STRING IF version
;
; Opt. Outputs: None.
;
; Keywords    : SOURCE     : STRING source filter ie 'sci'
;               CD_VERSION : STRING cd version ie 'a'
;               SW_VERSION : STRING sw version ie '2_3'
;
; Written     :	Version 0.0, 03/09/03
;
; Modified    :
;
; Version     :	Version 0.0, 03/09/03
;-
;**********************************************************

FUNCTION rcs_if_version, SOURCE=source, CD_VERSION=cd_version, SW_VERSION=sw_version

  ; set up defaults if keywords undefined

  IF N_ELEMENTS(source) EQ 0 THEN source = '*'

  IF N_ELEMENTS(cd_version) EQ 0 THEN cd_version = '*'

  IF N_ELEMENTS(sw_version) EQ 0 THEN sw_version = '*'

  IF source EQ '' AND cd_version EQ '' AND sw_version EQ '' THEN RETURN, ''

  ; turn any ''s into '*'s

  IF source EQ '' THEN source = '*'

  IF cd_version EQ '' THEN cd_version = '*'

  IF sw_version EQ '' THEN sw_version = '*'

  IF source EQ '*' AND cd_version EQ '*' AND sw_version EQ '*' THEN RETURN, '*'

  RETURN, source+'_'+cd_version+'_'+sw_version

END
