;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_INCREASE_STORAGE
;
; Purpose     :	Increases size of storage array.
;
; Explanation : Increases size of storage array.
;
; Use         : < rcs_increase_storage, header, data>
;
; Inputs      : header : STRUCTURE header info
;               data   : ARRAY storage array
;
; Opt. Inputs : None.
;
; Outputs     :
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, Martin Carter, RAL, 08/07/02
;
; Modified    : Version 0.1, 18/09/03
;                 Modified so that instead of doubling size of array just adds 100 samples
;                 Use TEMPORARY to restrict storage space.
;
; Version     :	Version 0.1, 18/09/03
;-
;**********************************************************

PRO rcs_increase_storage, header, data

  ; increase size of data array if necessary and possible
  ; can get into a loop here because needs temporary array
  ; prevent by using in place algorithm

  CATCH, error_status

  IF error_status NE 0 THEN BEGIN

    ;rcs_message, 'Error index: '+STRING(Error_status),/INFORMATIONAL
    rcs_message, 'Error message:'+!ERR_STRING,/INFORMATIONAL
    rcs_message, 'Data size reduced for : '+header.datatype,/INFORMATIONAL

    CATCH, /CANCEL

    IF header.npoints EQ 1 THEN BEGIN

      ; only use one point

      header.npoints = 0

    ENDIF ELSE BEGIN

      ; reduce no of samples

      FOR k = 0, header.npoints/2 - 1 DO data[k] = data[header.npoints-header.npoints/2+k]

      header.npoints = header.npoints/2

      header.tstart = data[0].time

    ENDELSE

  ENDIF ELSE BEGIN

    IF N_ELEMENTS(data) GT 1000 THEN BEGIN
      temp = data[0:1000]
      data = [TEMPORARY(data),temp]
    ENDIF ELSE data = [data,data]

  ENDELSE

END
