;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_INFO
;
; Purpose     :	Returns position of first set of sync markers '146f2e'
;
; Use         : < result = RCS_GET_CCSNM_SYNC(data) >
;
; Inputs      : data : BYTARR CCSNM EDB data stream.
;
; Opt. Inputs : None.
;
; Outputs     : result : LONARR indices of sync markers encountered or -1 if none
;
; Opt. Outputs: None.
;
; Keywords    : COUNT : INT returns no. of markers found.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	Version 0.1, 14/03/01
;                 Removed ids from rcs_text and this argument list.
;
; Version     :	Version 0.1, 14/03/01
;-
;**********************************************************

PRO rcs_info, headers, index, current_type, current_subc, previous_type, previous_subc

  ; used for debugging

  RETURN

  current_header = headers[index]

  IF index-1 GE 0 THEN BEGIN

    previous_header = headers[index-1]

    rcs_text, '  PREVIOUS FILE : ' + previous_header.header.info.name
    rcs_text, '  PREVIOUS HEADER TIME : ' + anytim2cal(previous_header.header.time)

  ENDIF

  rcs_text, '  PREVIOUS SUBCOMMUTATION INDEX : ' + rcs_strtrim(FIX(previous_subc))
  rcs_text, '  PREVIOUS TYPE : ' + rcs_strtrim(FIX(previous_type))

  rcs_text, '  CURRENT FILE : ' + current_header.header.info.name
  rcs_text, '  CURRENT HEADER TIME : ' + anytim2cal(current_header.header.time)
  rcs_text, '  CURRENT SUBCOMMUTATION INDEX : ' + rcs_strtrim(FIX(current_subc))
  rcs_text, '  CURRENT TYPE : ' + rcs_strtrim(FIX(current_type))

  IF index+1 LT N_ELEMENTS(headers) THEN BEGIN

    next_header = headers[index+1]

    rcs_text, '  NEXT FILE : ' + next_header.header.info.name
    rcs_text, '  NEXT HEADER TIME : ' + anytim2cal(next_header.header.time)

  ENDIF

END