;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IPAD
;
; Purpose     :	Constructs IPAD IF data.
;
; Use         : < rcs_ipad, use, edb, time, sc, flag, lut_no, $
;                     epad_table, fgm, hist_mode >
;
; Inputs      : ipad      : LONARR[energies,detectors,sectors] = [2,3,16] IPAD counts
;                            sets to make.
;               edb        : BYTARR EDB packet
;               time       : DOUBLE TAI time of EDB
;               sc         : STRING character giving spacecraft ID
;               vs         : STRING IF version 'sss_v_a_b'
;               flag       : BYTE flag bits
;               lut_no     : INT IES LUT 0:3 (0:8 in histogram mode)
;               epad_table : FLAG indicating epad table A (0) or B (1)
;               fgm        : FLAG indicating whether mag field available
;                            in all sectors
;               hist_mode  : FLAG indicating IES histogram mode active
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Modified    :
;
; Version     :	Version 0.0, 23/07/02
;-
;**********************************************************

PRO rcs_ipad, ipad, time, sc, vs, mvals, flag

  ; rotate to [sectors,detectors,energies]

  ipad = TRANSPOSE(ipad,[2,1,0])

  ; set up 3D array [sectors, detectors, energies]

  ipad_3d = FLTARR(16,12,2)

  ; get detectors for each of the 16 sectors [3,16]

  tab = rcs_decode_m ( mvals, /IIMS)

  ; loop through sectors
  ; select 3 detectors used for each sector based on m value

  FOR s=0,15 DO ipad_3d[s,tab[*,s],*] = ipad[s,*,*]

  rcs_add_ipad, sc, vs, time, ipad_3d, mvals, flag

END
