;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_PROCESS_EDB
;
; Purpose     :	Processes EDB data from science data stream.
;
; Explanation : Processes EDB data from science data stream.
;
; Use         : < rcs_process_edb, edb, time, type, subc, use, sc, SUBC_INVALID=subc_invalid >
;
; Inputs      : edb     : BYTARR EDB packet
;               time    : DOUBLE TAI time of EDB
;               type    : INT indicates telemetry mode of packet
;                           0 : nm
;                           1 : bm1
;                           2 : bm2
;                           3 : bm3
;               subc    : INT subcommutation index.
;               use     : STRUCTURE containing flags indicating which IF data
;                            sets to make.
;               sc      : STRING character giving spacecraft ID
;               vs      : STRING IF version 'sss_v_a_b'
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : SUBC_INVALID : FLAG indicating subcommutation index jump
;               GAP_ERROR    : FLAG indicating next packet does not follow consecutively.
;
; Written     :	Version 0.0, 16/1/01
;
; Modified    :	Version 0.1, 10/2/01
;                 Added check for use.scinfo.
;               Version 0.2, 12/2/01
;                 Removed silent keyword.
;               Version 0.3, 14/03/01
;                 Removed ids from rcs_check_edb and this argument list.
;               Version 0.4, 04/04/01
;                 Added keyword GAP_ERROR.
;               Version 0.5, 18/07/01
;                 Added CDROM version number.
;               Version 0.6, 08/07/02
;                 Used new routine rcs_check_bm.
;
; Version     :	Version 0.6, 08/07/02
;-
;**********************************************************

PRO rcs_process_edb, edb, time, type, subc, use, sc, vs, SUBC_INVALID=subc_invalid, GAP_ERROR=gap_error

  res = rcs_check_edb(edb, time, type, hist_mode, flag, lut_no, epad_table, fgm, $
                SUBC_INVALID=subc_invalid, GAP_ERROR=gap_error)

  ; add to scinfo IF data set

  IF use.scinfo THEN rcs_add_scinfo, sc, vs, time, [res, subc], flag, lut_no

  ; add to other data sets

  IF res EQ 0 THEN BEGIN

    ; check type

    IF rcs_check_bm(type) THEN BEGIN

      rcs_extract_bm, use, edb, time, sc, vs, flag, lut_no, epad_table, fgm, hist_mode

    ENDIF ELSE BEGIN

      rcs_extract_nm, use, edb, time, sc, vs, flag, lut_no, epad_table, fgm, hist_mode

    ENDELSE

  ENDIF

END
