;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_READ_DATFIL
;
; Purpose     :	Reads RAPID dat file record.
;
; Explanation :	Reads RAPID dat file record.
;               Cannot get /F77_UNFORMATTED KEYWORD to work properly -- though should simplify reading data.
;               Possibly little-endian / big-endian problem ?
;               Have to do the UNIX FORTRAN unformatting explicitly.
;
; Use         : < res = rcs_read_datfil (unit, time, data, edb_no, edb_mode) >
;
; Inputs      : unit      : LONG logical unit number.
;
; Opt. Inputs : None.
;
; Outputs     : res       : INT flag 0 : OK , 1 : error
;               time      : DOUBLE TAI time.
;               data      : BYTARR[*] data bytes.
;               edb_no    : LONG edb number.
;               edb_mode  : LONG mode of each EDB :
;                             0 : NM, 1-3 : BMx
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 15/1/01
;
; Modified    :	None.
;
; Version     :	Version 0.0, 15/1/01
;-
;**********************************************************

FUNCTION rcs_read_datfil, unit, time, data, edb_no, edb_mode

  ; set up read variables

  length0 = 0L

  length1 = 0L

  edb_utc = '123456789012345678901234'

  ndat = 0L

  edb_no = 0L

  edb_mode = 0L

  ON_IOERROR, error

  ; 1st record

  READU, unit, length0, edb_utc, ndat, edb_no, edb_mode, length1

  BYTEORDER, length0, /LSWAP, /SWAP_IF_LITTLE_ENDIAN

  time = anytim2tai(edb_utc)

  BYTEORDER, ndat, /LSWAP, /SWAP_IF_LITTLE_ENDIAN

  BYTEORDER, edb_no, /LSWAP, /SWAP_IF_LITTLE_ENDIAN

  BYTEORDER, edb_mode, /LSWAP, /SWAP_IF_LITTLE_ENDIAN

  BYTEORDER, length1, /LSWAP, /SWAP_IF_LITTLE_ENDIAN

  IF length0 NE length1 OR length0 NE 36 THEN BEGIN

    rcs_message, 'WARNING, INVALID FILE FORMAT', /INFORMATIONAL

    RETURN, 1

  ENDIF

  ; 2nd record

  data = BYTARR(ndat)

  READU, unit, length0, data, length1

  BYTEORDER, length0, /LSWAP, /SWAP_IF_LITTLE_ENDIAN

  BYTEORDER, length1, /LSWAP, /SWAP_IF_LITTLE_ENDIAN

  IF length0 NE length1 OR length0 NE ndat THEN BEGIN

    rcs_message, 'WARNING, INVALID FILE FORMAT', /INFORMATIONAL

    RETURN, 1

  ENDIF

  ; return data

  RETURN, 0

  ; error

  error : rcs_message, !ERR_STRING, /INFORMATIONAL

  RETURN, 1

END
