;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RECONSTRUCT_M
;
; Purpose     :	Reconstructs the mvals array giving detectors used for each sector.
;
; Use         : < m = RCS_RECONSTRUCT_M(ms) >
;
; Inputs      : ms : [16]BYTARR m values for each sector.
;
; Opt. Inputs : None.
;
; Outputs     : m : BYTARR[8] containing the [8]BYTE m values determining the detectors
;                   for each sector.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 08/07/02
;
; Modified    : Version 0.1, 07/10/03
;                 Fixed bug which left mvals as INTARR rather than BYTARR
;                 Explicitly truncated m-valeus to 4 bits
;
; Version     :	Version 0.1, 07/10/03
;-
;**********************************************************

FUNCTION rcs_reconstruct_m, ms, IIMS=iims, MVAL=mval

    ; set high and low nibbles for m-values
    ; high nibble first followed by low nibble for each byte

    mms = REFORM(ms,2,8)

    ; explicitly ensure that ms are 4 bits only to avoid confusion if
    ; for example fill values are used

    mms = mms AND 'F'XB

    ; fold sectors into 1st and 2nd nibbles of each byte

    mvals = REFORM(mms[1,*] OR ISHFT(mms[0,*],4))

  RETURN, mvals

END
