;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RECONSTRUCT_MSIGNS
;
; Purpose     :	Reconstructs the mvals array to giving B field orientation for each sector.
;
; Explanation : Reverses rcs_decode_msigns. 
;
; Use         : < m = RCS_RECONSTRUCT_MSIGNS(tab) >
;
; Inputs      : tab : [16]INTARR indicating orientation for each sector.
;                     0 : B-field parallel to the 1st IIMS direction for this sector
;                     1 : B-field is anti-parallel to the 1st IIMS direction 
; 
; Opt. Inputs : None.
;
; Outputs     : m : BYTARR[2] containing the msigns determining B-field parallel or 
;                   anti-parallel to 1st detector in IIMS.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 08/07/02
;
; Modified    :	None.
;
; Version     :	Version 0.0, 08/07/02
;-
;**********************************************************

FUNCTION rcs_reconstruct_msigns, tab

  ; construct bit table

  msigns = BYTARR(2)

  FOR j = 0, 1 DO BEGIN
   
    FOR k = 0, 6 DO BEGIN
   
      msigns[j] = ISHFT(msigns[j] OR tab[8*j+k],1)

    ENDFOR

    msigns[j] = msigns[j] OR tab[8*j+k]

  ENDFOR

  RETURN, msigns

END
