;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RECONSTRUCT_MVALS
;
; Purpose     :	Reconstructs mvals from MDATA
;
; Explanation : Reconstructs mvals from MDATA
;
; Use         : < mvals = rcs_reconstruct_mvals(mdata) >
;
; Inputs      : mdata : FLTARR[32] m values and msigns
;
; Opt. Inputs : None.
;
; Outputs     : mvals : BYTARR[11] containing the [8]BYTE m values determining the detectors
;                       for each sector, [2]BYTE msigns determining B-field parallel or
;                       anti-parallel to 1st detector in IIMS and [1]BYTE flag indicating EPAD
;                       table A or B.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 23/07/02
;
; Modified    : Version 0.1, 07/10/03
;                 Fixed bugs which left mvals as INTARR rather than BYTARR
;
; Version     :	Version 0.1, 07/10/03
;-
;**********************************************************

FUNCTION rcs_reconstruct_mvals, mdata

  ; convert mdata to bytes
  ; NB fill value used was -99

  mdata = BYTE(mdata)

  ; get ms

  m = rcs_reconstruct_m(mdata[0:15])

  ; get msigns

  msigns = rcs_reconstruct_msigns(mdata[16:31])

  ; set up mvals array
  ; assume epad_table is 1

  mvals = [m, msigns, 1B]

  RETURN, mvals

END
