;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_REPROCESS_IF
;
; Purpose     :	Reprocesses IF data sets : ESPCT, I3DD.
;
; Explanation :	Converts CLEAN to ESPCT. Adjusts I3DD header. Adjusts HSPCT and ISPCT energy efficiencies.
;
; Use         : < rcs_reprocess_if, sc, day>
;
; Inputs      : sc     : STRING character giving SC.
;               day    : STRING IF day in format yymmdd
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 08/04/01
;
; Modified    : Version 0.1, 08/05/01
;                 Added I3DD SC2 timing correction.
;               Version 0.2, 10/05/01
;                 Used bits of reprocess_if flag to select reprocessing options.
;               Version 0.3, 10/06/01
;                 Added reprocess HK1/HK32.
;               Version 0.4, 18/07/01
;                 Replaced argument name with day.
;               Version 0.5, 12/02/02
;                 Reprocess EPAD_16 data.
;               Version 0.6, 13/03/02
;                 Changed sc argument to sc_root in rcs_restore_ifdata.
;               Version 0.7, 16/09/03
;                 Removed reporcessing of version 1.9 IF files.
;
; Version     :	Version 0.7, 16/09/03
;-
;**********************************************************

PRO rcs_reprocess_if, sc, day, REPROCESS_IF=reprocess_if

  IF NOT KEYWORD_SET(reprocess_if) THEN RETURN

  ; check reprocessing options

 ; IF 1 THEN BEGIN

    ; reprocess EPAD_16 data

;    IF rcs_restore_ifdata ( rcs_get_scname(sc), 'IES_EPAD_16', day, header, data) THEN BEGIN

;      IF STRPOS(header.version,'1.9') GE 0 THEN BEGIN

;        FOR p = 0, header.npoints-1 DO BEGIN

;          d = data[p].data

;          dd = d

;          dd[*] = 0

;          oldtab = rcs_decode_m_old(data[p].mvals)

;          newtab = rcs_decode_m(data[p].mvals)

;          FOR s = 0, 15 DO BEGIN

;            dets = d[s,oldtab[*,s],*]

;            dd[s,newtab[*,s],*] = dets

;          ENDFOR

;          data[p].data = dd

;          ch_positions = rcs_get_luts ( sc, 'EPAD', lut_times, lut_map, count_calibration, energy_calibration, energy_efficiency)

;          header.ch_positions = ch_positions

;          header.version = STRMID(header.version,0,2) +'2.0'

;        ENDFOR

        ; save out the data -- uses header.datatype to determine where to put file

;        rcs_save_ifset, header, data, day

;      ENDIF ELSE rcs_text, 'WARNING, IF file version '+header.version

;    ENDIF

    ; reprocess IPAD_16 data

;    IF rcs_restore_ifdata ( rcs_get_scname(sc), 'IIMS_IPAD_16', day, header, data) THEN BEGIN
;
;      IF STRPOS(header.version,'2.0') LT 0 THEN BEGIN
;
;        FOR p = 0, header.npoints-1 DO BEGIN
;
;          d = data[p].data
;
;          dd = d
;
;          dd[*] = 0
;
;          oldtab = rcs_decode_m_old(data[p].mvals)
;
;          newtab = rcs_decode_m(data[p].mvals)
;
;          FOR s = 0, 15 DO BEGIN
;
;            dets = d[s,oldtab[*,s],*]
;
;            dd[s,newtab[*,s],*] = dets
;
;          ENDFOR
;
;          data[p].data = dd
;
;        ENDFOR
;
;        ; save out the data -- uses header.datatype to determine where to put file
;
;        rcs_save_ifset, header, data, day
;
;      ENDIF ELSE rcs_text, 'WARNING, IF file already version 2.0'
;
;    ENDIF

;  ENDIF

END
