;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RESAMPLE_HIST
;
; Purpose     :	Resamples histogram data according to specified binning scheme.
;
; Explanation : Resamples histogram data according to specified binning scheme.
;
; Use         : < samples = rcs_resample_hist( sc, time, strip, lut_no, ehist)  >
;
; Inputs      : sc          : STRING character containing spacecraft ID
;               time        : DOUBLE TAI time of start of data
;               strip       : INT IES detector number 0-8
;               lut_no      : INT LUT number giving integration time
;                             NB lut_no has not been adjusted for LUT changes
;               ehist       : BYTARR(256) histogram data
;
; Opt. Inputs : None.
;
; Outputs     : samples   : FLOAT histogram data sampled as for LUT
;
; Opt. Outputs: None.
;
; Keywords    : NM : Flag indicating NM sampling
;               BM : FLag indicating BM sampling
;               BIN_POSITIONS : Named variable to return bin positions.
;               NO_OF_ENERGIES : Named variable to return no_of_energies.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 13/12/00
;                 Added Keywords NM, BM, BIN_POSITIONS and NO_OF_ENERGIES.
;               Version 0.2, 26/1/01
;                 Added 16 energy bins as default mode.
;                 Fixed bug where included an extra bin in calculation of histogram samples.
;               Version 0.3, 01/12/03
;                 Chanegd argument list of rcs get luts.
;
; Version     :	Version 0.3, 01/12/03
;-
;**********************************************************

FUNCTION rcs_resample_hist, sc, time, strip, lut_no, ehist, NM=nm, BM=bm, BIN_POSITIONS=bin_positions, NO_OF_ENERGIES=no_of_energies

  IF KEYWORD_SET(bm) THEN iftype = 'E3DDBM' $
  ELSE IF KEYWORD_SET(nm) THEN iftype='E3DD' $
  ELSE iftype = 'E3DDF'

  ; get bin positions

  ch_positions = rcs_get_luts ( sc, iftype, lut_times, NO_OF_ENERGIES=no_of_energies)

  ; get lut adjusted for changes

  lut = rcs_adjust_lut (time, lut_no, lut_times)

  ; get bin positions for detector [2,nenergies]

  bin_positions = ch_positions[*,*,strip,lut]

  ; resample ehist array --> [nenergies]

  res = FLTARR(no_of_energies)

  FOR k = 0, no_of_energies-1 DO res[k] = TOTAL(ehist[bin_positions[0,k]:bin_positions[1,k]-1])

  RETURN, res

END