;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RESET_IF
;
; Purpose     :	Resets COMMON block data interfacing between RCS_EXTRACT and
;               plotiing software.
;
; Explanation : Resets RAL intermediate format data sets and extract data
;               in COMMON blocks. Asserts flag indicating that reset taken place.
;
; Use         : < rcs_reset_if >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 6/2/01
;                 Added pedestals and espct IF data set.
;               Version 0.2, 15/05/01
;                 Added CLEANBM2.
;               Version 0.3, 08/02/02
;                 Added EPAD2.
;
; Version     :	Version 0.3, 08/02/02
;-
;**********************************************************

PRO rcs_reset_if

  COMMON rcs_extract_block, tmax, data_reset

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  ; reset RAL intermediate format common blocks

  tmax = 0

  ; set data reset

  data_reset = 3

  e3ddnm_header = 0
  e3ddnm_data = 0

  ehist_header = 0
  ehist_data = 0

  e3ddbm_header = 0
  e3ddbm_data = 0

  epad_header = 0
  epad_data = 0

  epad2_header = 0
  epad2_data = 0

  ehk_header = 0
  ehk_data = 0

  clean_header = 0
  clean_data = 0

  cleanbm_header = 0
  cleanbm_data = 0

  cleanbm2_header = 0
  cleanbm2_data = 0

  espct_header = 0
  espct_data = 0

  pedestal_header = 0
  pedestal_data = 0

  i3dd_header_H = 0
  i3dd_data_H = 0

  i3dd_header_He = 0
  i3dd_data_He = 0

  i3dd_header_CNO = 0
  i3dd_data_CNO = 0

  ipad_header = 0
  ipad_data = 0

  hspct_header = 0
  hspct_data = 0

  ispct_header_He = 0
  ispct_data_He = 0

  ispct_header_CNO = 0
  ispct_data_CNO = 0

  mtrx_header = 0
  mtrx_data = 0

  sglbm_header = 0
  sglbm_data = 0

  sgl01_header = 0
  sgl01_data = 0

  sgl2_header = 0
  sgl2_data = 0

  sgl3_header = 0
  sgl3_data = 0

  hk1_header = 0
  hk1_data = 0

  hk2_header = 0
  hk2_data = 0

  hk4_header = 0
  hk4_data = 0

  hk8_header = 0
  hk8_data = 0

  hk32_header = 0
  hk32_data = 0

  scinfo_header = 0
  scinfo_data = 0

END
